/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.manual.RelationDefineUtil;
import org.apache.skywalking.oap.server.core.query.entity.Call;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.ITopologyQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2TopologyQueryDAO
implements ITopologyQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2TopologyQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public List<Call.CallDetail> loadSpecifiedServerSideServiceRelations(Downsampling downsampling, long startTB, long endTB, List<Integer> serviceIds) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)"service_relation_server_side");
        return this.loadServiceCalls(tableName, startTB, endTB, "source_service_id", "dest_service_id", serviceIds, false);
    }

    public List<Call.CallDetail> loadSpecifiedClientSideServiceRelations(Downsampling downsampling, long startTB, long endTB, List<Integer> serviceIds) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)"service_relation_client_side");
        return this.loadServiceCalls(tableName, startTB, endTB, "source_service_id", "dest_service_id", serviceIds, true);
    }

    public List<Call.CallDetail> loadServerSideServiceRelations(Downsampling downsampling, long startTB, long endTB) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)"service_relation_server_side");
        return this.loadServiceCalls(tableName, startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<Integer>(0), false);
    }

    public List<Call.CallDetail> loadClientSideServiceRelations(Downsampling downsampling, long startTB, long endTB) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)"service_relation_client_side");
        return this.loadServiceCalls(tableName, startTB, endTB, "source_service_id", "dest_service_id", new ArrayList<Integer>(0), true);
    }

    public List<Call.CallDetail> loadSpecifiedDestOfServerSideEndpointRelations(Downsampling downsampling, long startTB, long endTB, int destEndpointId) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)"endpoint_relation_server_side");
        List<Call.CallDetail> calls = this.loadEndpointFromSide(tableName, startTB, endTB, "source_endpoint_id", "dest_endpoint_id", destEndpointId, false);
        calls.addAll(this.loadEndpointFromSide(tableName, startTB, endTB, "source_endpoint_id", "dest_endpoint_id", destEndpointId, true));
        return calls;
    }

    private List<Call.CallDetail> loadServiceCalls(String tableName, long startTB, long endTB, String sourceCName, String destCName, List<Integer> serviceIds, boolean isClientSide) throws IOException {
        Object[] conditions = new Object[serviceIds.size() * 2 + 2];
        conditions[0] = startTB;
        conditions[1] = endTB;
        StringBuilder serviceIdMatchSql = new StringBuilder();
        if (serviceIds.size() > 0) {
            serviceIdMatchSql.append("and (");
            for (int i = 0; i < serviceIds.size(); ++i) {
                serviceIdMatchSql.append(sourceCName + "=? or " + destCName + "=? ");
                conditions[i * 2 + 2] = serviceIds.get(i);
                conditions[i * 2 + 1 + 2] = serviceIds.get(i);
                if (i == serviceIds.size() - 1) continue;
                serviceIdMatchSql.append("or ");
            }
            serviceIdMatchSql.append(")");
        }
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id from " + tableName + " where " + "time_bucket" + ">= ? and " + "time_bucket" + "<=? " + serviceIdMatchSql.toString() + " group by " + "entity_id", conditions);){
            this.buildCalls(resultSet, calls, isClientSide);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return calls;
    }

    private List<Call.CallDetail> loadEndpointFromSide(String tableName, long startTB, long endTB, String sourceCName, String destCName, int id, boolean isSourceId) throws IOException {
        Object[] conditions = new Object[]{startTB, endTB, id};
        ArrayList<Call.CallDetail> calls = new ArrayList<Call.CallDetail>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id from " + tableName + " where " + "time_bucket" + ">= ? and " + "time_bucket" + "<=? and " + (isSourceId ? sourceCName : destCName) + "=? group by " + "entity_id", conditions);){
            this.buildCalls(resultSet, calls, isSourceId);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return calls;
    }

    private void buildCalls(ResultSet resultSet, List<Call.CallDetail> calls, boolean isClientSide) throws SQLException {
        while (resultSet.next()) {
            Call.CallDetail call = new Call.CallDetail();
            String entityId = resultSet.getString("entity_id");
            RelationDefineUtil.RelationDefine relationDefine = RelationDefineUtil.splitEntityId((String)entityId);
            call.setSource(Integer.valueOf(relationDefine.getSource()));
            call.setTarget(Integer.valueOf(relationDefine.getDest()));
            call.setComponentId(Integer.valueOf(relationDefine.getComponentId()));
            if (isClientSide) {
                call.setDetectPoint(DetectPoint.CLIENT);
            } else {
                call.setDetectPoint(DetectPoint.SERVER);
            }
            call.generateID();
            calls.add(call);
        }
    }
}

