/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.Downsampling;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValue;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntKeyLongValueHashMap;
import org.apache.skywalking.oap.server.core.query.entity.IntValues;
import org.apache.skywalking.oap.server.core.query.entity.KVInt;
import org.apache.skywalking.oap.server.core.query.entity.Thermodynamic;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.sql.KeyValues;
import org.apache.skywalking.oap.server.core.query.sql.Where;
import org.apache.skywalking.oap.server.core.storage.model.ModelName;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao.H2SQLExecutor;

public class H2MetricsQueryDAO
extends H2SQLExecutor
implements IMetricsQueryDAO {
    private JDBCHikariCPClient h2Client;

    public H2MetricsQueryDAO(JDBCHikariCPClient h2Client) {
        this.h2Client = h2Client;
    }

    public IntValues getValues(String indName, Downsampling downsampling, long startTB, long endTB, Where where, String valueCName, Function function) throws IOException {
        String op;
        String tableName = ModelName.build((Downsampling)downsampling, (String)indName);
        List whereKeyValues = where.getKeyValues();
        switch (function) {
            case Avg: {
                op = "avg";
                break;
            }
            default: {
                op = "sum";
            }
        }
        ArrayList<String> ids = new ArrayList<String>(20);
        StringBuilder whereSql = new StringBuilder();
        if (whereKeyValues.size() > 0) {
            whereSql.append("(");
            for (int i = 0; i < whereKeyValues.size(); ++i) {
                if (i != 0) {
                    whereSql.append(" or ");
                }
                KeyValues keyValues = (KeyValues)whereKeyValues.get(i);
                StringBuilder valueCollection = new StringBuilder();
                List values = keyValues.getValues();
                for (int valueIdx = 0; valueIdx < values.size(); ++valueIdx) {
                    if (valueIdx != 0) {
                        valueCollection.append(",");
                    }
                    String id = (String)values.get(valueIdx);
                    ids.add(id);
                    valueCollection.append("'").append(id).append("'");
                }
                whereSql.append(keyValues.getKey()).append(" in (").append((CharSequence)valueCollection).append(")");
            }
            whereSql.append(") and ");
        }
        IntValues intValues = new IntValues();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select entity_id id, " + op + "(" + valueCName + ") value from " + tableName + " where " + whereSql + "time_bucket" + ">= ? and " + "time_bucket" + "<=? group by " + "entity_id", new Object[]{startTB, endTB});){
            while (resultSet.next()) {
                KVInt kv = new KVInt();
                kv.setId(resultSet.getString("id"));
                kv.setValue(resultSet.getLong("value"));
                intValues.getValues().add(kv);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return this.orderWithDefault0(intValues, ids);
    }

    public IntValues getLinearIntValues(String indName, Downsampling downsampling, List<String> ids, String valueCName) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)indName);
        StringBuilder idValues = new StringBuilder();
        for (int valueIdx = 0; valueIdx < ids.size(); ++valueIdx) {
            if (valueIdx != 0) {
                idValues.append(",");
            }
            idValues.append("'").append(ids.get(valueIdx)).append("'");
        }
        IntValues intValues = new IntValues();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, "select id, " + valueCName + " from " + tableName + " where id in (" + idValues.toString() + ")", new Object[0]);){
            while (resultSet.next()) {
                KVInt kv = new KVInt();
                kv.setId(resultSet.getString("id"));
                kv.setValue(resultSet.getLong(valueCName));
                intValues.getValues().add(kv);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return this.orderWithDefault0(intValues, ids);
    }

    private IntValues orderWithDefault0(IntValues origin, List<String> expectedOrder) {
        IntValues intValues = new IntValues();
        expectedOrder.forEach(id -> {
            KVInt e = new KVInt();
            e.setId(id);
            e.setValue(origin.findValue(id, 0));
            intValues.addKVInt(e);
        });
        return intValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Thermodynamic getThermodynamic(String indName, Downsampling downsampling, List<String> ids, String valueCName) throws IOException {
        String tableName = ModelName.build((Downsampling)downsampling, (String)indName);
        StringBuilder idValues = new StringBuilder();
        for (int valueIdx = 0; valueIdx < ids.size(); ++valueIdx) {
            if (valueIdx != 0) {
                idValues.append(",");
            }
            idValues.append("'").append(ids.get(valueIdx)).append("'");
        }
        ArrayList thermodynamicValueCollection = new ArrayList();
        HashMap thermodynamicValueMatrix = new HashMap();
        try (Connection connection = this.h2Client.getConnection();){
            Thermodynamic thermodynamic = new Thermodynamic();
            int numOfSteps = 0;
            int axisYStep = 0;
            try (ResultSet resultSet = this.h2Client.executeQuery(connection, "select step step, num_of_steps num_of_steps, detail_group detail_group, id  from " + tableName + " where id in (" + idValues.toString() + ")", new Object[0]);){
                while (resultSet.next()) {
                    axisYStep = resultSet.getInt("step");
                    String id2 = resultSet.getString("id");
                    numOfSteps = resultSet.getInt("num_of_steps") + 1;
                    String value = resultSet.getString("detail_group");
                    IntKeyLongValueHashMap intKeyLongValues = new IntKeyLongValueHashMap(5);
                    intKeyLongValues.toObject(value);
                    ArrayList<Long> axisYValues = new ArrayList<Long>();
                    for (int i = 0; i < numOfSteps; ++i) {
                        axisYValues.add(0L);
                    }
                    for (IntKeyLongValue intKeyLongValue : intKeyLongValues.values()) {
                        axisYValues.set(intKeyLongValue.getKey(), intKeyLongValue.getValue());
                    }
                    thermodynamicValueMatrix.put(id2, axisYValues);
                }
                ids.forEach(id -> {
                    if (thermodynamicValueMatrix.containsKey(id)) {
                        thermodynamicValueCollection.add(thermodynamicValueMatrix.get(id));
                    } else {
                        thermodynamicValueCollection.add(new ArrayList());
                    }
                });
            }
            thermodynamic.fromMatrixData(thermodynamicValueCollection, numOfSteps);
            thermodynamic.setAxisYStep(axisYStep);
            Thermodynamic thermodynamic2 = thermodynamic;
            return thermodynamic2;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

