/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.h2.dao;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.oap.server.core.query.entity.Attribute;
import org.apache.skywalking.oap.server.core.query.entity.Database;
import org.apache.skywalking.oap.server.core.query.entity.Endpoint;
import org.apache.skywalking.oap.server.core.query.entity.LanguageTrans;
import org.apache.skywalking.oap.server.core.query.entity.Service;
import org.apache.skywalking.oap.server.core.query.entity.ServiceInstance;
import org.apache.skywalking.oap.server.core.register.ServiceInstanceInventory;
import org.apache.skywalking.oap.server.core.source.DetectPoint;
import org.apache.skywalking.oap.server.core.storage.query.IMetadataQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCHikariCPClient;

public class H2MetadataQueryDAO
implements IMetadataQueryDAO {
    private static final Gson GSON = new Gson();
    private JDBCHikariCPClient h2Client;
    private int metadataQueryMaxSize;

    public H2MetadataQueryDAO(JDBCHikariCPClient h2Client, int metadataQueryMaxSize) {
        this.h2Client = h2Client;
        this.metadataQueryMaxSize = metadataQueryMaxSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int numOfService(long startTimestamp, long endTimestamp) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(5);
        sql.append("select count(*) num from ").append("service_inventory").append(" where ");
        this.setTimeRangeCondition(sql, condition, startTimestamp, endTimestamp);
        sql.append(" and ").append("is_address").append("=0");
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("num");
            return n;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int numOfEndpoint() throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList condition = new ArrayList(5);
        sql.append("select count(*) num from ").append("endpoint_inventory").append(" where ");
        sql.append("detect_point").append("=").append(DetectPoint.SERVER.ordinal());
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("num");
            return n;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int numOfConjectural(int nodeTypeValue) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Integer> condition = new ArrayList<Integer>(5);
        sql.append("select count(*) num from ").append("service_inventory").append(" where ");
        sql.append("node_type").append("=?");
        condition.add(nodeTypeValue);
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("num");
            return n;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<Service> getAllServices(long startTimestamp, long endTimestamp) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Database> getAllDatabases() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Service> searchServices(long startTimestamp, long endTimestamp, String keyword) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Service searchService(String serviceCode) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(5);
        sql.append("select * from ").append("service_inventory").append(" where ");
        sql.append("is_address").append("=?");
        condition.add(0);
        sql.append(" and ").append("name").append(" = ?");
        condition.add(serviceCode);
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            if (!resultSet.next()) return null;
            Service service = new Service();
            service.setId(resultSet.getInt("sequence"));
            service.setName(resultSet.getString("name"));
            Service service2 = service;
            return service2;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public List<Endpoint> searchEndpoint(String keyword, String serviceId, int limit) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(5);
        sql.append("select * from ").append("endpoint_inventory").append(" where ");
        sql.append("service_id").append("=?");
        condition.add(serviceId);
        if (!Strings.isNullOrEmpty((String)keyword)) {
            sql.append(" and ").append("name").append(" like '%").append(keyword).append("%' ");
        }
        sql.append(" and ").append("detect_point").append(" = ?");
        condition.add(DetectPoint.SERVER.ordinal());
        sql.append(" limit ").append(limit);
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            while (resultSet.next()) {
                Endpoint endpoint = new Endpoint();
                endpoint.setId(resultSet.getInt("sequence"));
                endpoint.setName(resultSet.getString("name"));
                endpoints.add(endpoint);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return endpoints;
    }

    public List<ServiceInstance> getServiceInstances(long startTimestamp, long endTimestamp, String serviceId) throws IOException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> condition = new ArrayList<Object>(5);
        sql.append("select * from ").append("service_instance_inventory").append(" where ");
        this.setTimeRangeCondition(sql, condition, startTimestamp, endTimestamp);
        sql.append(" and ").append("service_id").append("=?");
        condition.add(serviceId);
        ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
        try (Connection connection = this.h2Client.getConnection();
             ResultSet resultSet = this.h2Client.executeQuery(connection, sql.toString(), condition.toArray(new Object[0]));){
            while (resultSet.next()) {
                ServiceInstance serviceInstance = new ServiceInstance();
                serviceInstance.setId(resultSet.getString("sequence"));
                serviceInstance.setName(resultSet.getString("name"));
                serviceInstance.setInstanceUUID(resultSet.getString("instance_uuid"));
                String propertiesString = resultSet.getString("properties");
                if (!Strings.isNullOrEmpty((String)propertiesString)) {
                    JsonObject properties = (JsonObject)GSON.fromJson(propertiesString, JsonObject.class);
                    for (Map.Entry property : properties.entrySet()) {
                        String key = (String)property.getKey();
                        String value = ((JsonElement)property.getValue()).getAsString();
                        if (key.equals("language")) {
                            serviceInstance.setLanguage(LanguageTrans.INSTANCE.value(value));
                            continue;
                        }
                        if (key.equals("os_name")) {
                            serviceInstance.getAttributes().add(new Attribute("os_name", value));
                            continue;
                        }
                        if (key.equals("host_name")) {
                            serviceInstance.getAttributes().add(new Attribute("host_name", value));
                            continue;
                        }
                        if (key.equals("process_no")) {
                            serviceInstance.getAttributes().add(new Attribute("process_no", value));
                            continue;
                        }
                        if (key.equals("ipv4s")) {
                            List ipv4s = ServiceInstanceInventory.PropertyUtil.ipv4sDeserialize((String)properties.get("ipv4s").getAsString());
                            for (String ipv4 : ipv4s) {
                                serviceInstance.getAttributes().add(new Attribute("ipv4s", ipv4));
                            }
                            continue;
                        }
                        serviceInstance.getAttributes().add(new Attribute(key, value));
                    }
                }
                serviceInstances.add(serviceInstance);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        return serviceInstances;
    }

    private void setTimeRangeCondition(StringBuilder sql, List<Object> conditions, long startTimestamp, long endTimestamp) {
        sql.append(" ( (").append("heartbeat_time").append(" >= ? and ").append("register_time").append(" <= ? )");
        conditions.add(endTimestamp);
        conditions.add(endTimestamp);
        sql.append(" or (").append("register_time").append(" <= ? and ").append("heartbeat_time").append(" >= ? ) ) ");
        conditions.add(endTimestamp);
        conditions.add(startTimestamp);
    }

    private List<Service> buildServices(ResultSet resultSet) throws SQLException {
        ArrayList<Service> services = new ArrayList<Service>();
        while (resultSet.next()) {
            Service service = new Service();
            service.setId(resultSet.getInt("sequence"));
            service.setName(resultSet.getString("name"));
            services.add(service);
        }
        return services;
    }
}

