/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultIndividual;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultOrganisation;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.content.DefaultAttributeGroup;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultRangeElementDescription;
import org.apache.sis.metadata.iso.distribution.DefaultDistribution;
import org.apache.sis.metadata.iso.distribution.DefaultDistributor;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.spatial.DefaultDimension;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

final class MetadataReader {
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String[] SERVICES = new String[]{"wms_service", "wcs_service"};
    private static final String KEYWORD_SEPARATOR = ",";
    private static final VerticalCRS VERTICAL_CRS = null;
    private final Decoder decoder;
    private final String[] searchPath;
    private transient DefaultNameFactory nameFactory;
    private transient ResponsibleParty pointOfContact;

    MetadataReader(Decoder decoder) throws IOException {
        this.decoder = decoder;
        decoder.setSearchPath(SEARCH_PATH);
        this.searchPath = decoder.getSearchPath();
    }

    private void warning(Exception e) {
        this.decoder.listeners.warning(null, e);
    }

    private Errors errors() {
        return Errors.getResources((Locale)this.decoder.listeners.getLocale());
    }

    private String stringValue(String name) throws IOException {
        String value = this.decoder.stringValue(name);
        if (value != null && (value = value.trim()).isEmpty()) {
            value = null;
        }
        return value;
    }

    private static InternationalString toInternationalString(String value) {
        return value != null ? new SimpleInternationalString(value) : null;
    }

    private <T extends Enum<T>> T forEnumName(Class<T> enumType, String name) {
        Enum code = Types.forEnumName(enumType, (String)name);
        if (code == null && name != null) {
            this.decoder.listeners.warning(this.errors().getString((short)114, enumType, (Object)name), null);
        }
        return (T)code;
    }

    private <T extends CodeList<T>> T forCodeName(Class<T> codeType, String name) {
        CodeList code = Types.forCodeName(codeType, (String)name, (boolean)false);
        if (code == null && name != null) {
            this.decoder.listeners.warning(this.errors().getString((short)114, codeType, (Object)name), null);
        }
        return (T)code;
    }

    private static <T> void addIfAbsent(Collection<T> collection, T element) {
        if (!collection.contains(element)) {
            collection.add(element);
        }
    }

    private static <T> Set<T> addIfNonNull(Set<T> collection, T element) {
        if (element != null) {
            if (collection == null) {
                collection = new LinkedHashSet<T>(4);
            }
            collection.add(element);
        }
        return collection;
    }

    private static boolean canShare(CharSequence metadata, String attribute) {
        return attribute == null || metadata != null && metadata.toString().equals(attribute);
    }

    private static boolean canShare(Collection<String> metadata, String attribute) {
        return attribute == null || metadata.contains(attribute);
    }

    private static boolean canShare(OnlineResource resource, String url) {
        return url == null || resource != null && MetadataReader.canShare(resource.getLinkage().toString(), url);
    }

    private static boolean canShare(Address address, String email) {
        return email == null || address != null && MetadataReader.canShare(address.getElectronicMailAddresses(), email);
    }

    private OnlineResource createOnlineResource(String url) {
        if (url != null) {
            try {
                DefaultOnlineResource resource = new DefaultOnlineResource(new URI(url));
                resource.setProtocol("http");
                resource.setApplicationProfile("web browser");
                resource.setFunction(OnLineFunction.INFORMATION);
                return resource;
            }
            catch (URISyntaxException e) {
                this.warning(e);
            }
        }
        return null;
    }

    private static Address createAddress(String email) {
        if (email != null) {
            DefaultAddress address = new DefaultAddress();
            address.setElectronicMailAddresses(Collections.singleton(email));
            return address;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource url) {
        if (address != null || url != null) {
            DefaultContact contact = new DefaultContact();
            if (address != null) {
                contact.setAddresses(Collections.singleton(address));
            }
            if (url != null) {
                contact.setOnlineResources(Collections.singleton(url));
            }
            return contact;
        }
        return null;
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible keys, boolean isPointOfContact) throws IOException {
        String individualName = this.stringValue(keys.NAME);
        String organisationName = this.stringValue(keys.INSTITUTION);
        String email = this.stringValue(keys.EMAIL);
        String url = this.stringValue(keys.URL);
        if (individualName == null && organisationName == null && email == null && url == null) {
            return null;
        }
        Role role = this.forCodeName(Role.class, this.stringValue(keys.ROLE));
        if (role == null) {
            role = isPointOfContact ? Role.POINT_OF_CONTACT : keys.DEFAULT_ROLE;
        }
        ResponsibleParty responsibility = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource resource = null;
        if (responsibility != null) {
            contact = responsibility.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                resource = contact.getOnlineResource();
            }
            if (!MetadataReader.canShare(resource, url)) {
                resource = null;
                contact = null;
                responsibility = null;
            }
            if (!MetadataReader.canShare(address, email)) {
                address = null;
                contact = null;
                responsibility = null;
            }
            if (!(responsibility == null || MetadataReader.canShare((CharSequence)responsibility.getOrganisationName(), organisationName) && MetadataReader.canShare(responsibility.getIndividualName(), individualName))) {
                responsibility = null;
            }
        }
        if (responsibility == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(email);
                }
                if (resource == null) {
                    resource = this.createOnlineResource(url);
                }
                contact = MetadataReader.createContact(address, resource);
            }
            if (individualName != null || organisationName != null || contact != null) {
                DefaultIndividual party = null;
                if (individualName != null) {
                    party = new DefaultIndividual((CharSequence)individualName, null, null);
                }
                if (organisationName != null) {
                    party = new DefaultOrganisation((CharSequence)organisationName, null, party, null);
                }
                if (party == null) {
                    party = new AbstractParty();
                }
                if (contact != null) {
                    party.setContactInfo(Collections.singleton(contact));
                }
                responsibility = new DefaultResponsibleParty(role);
                ((DefaultResponsibleParty)responsibility).setParties(Collections.singleton(party));
            }
        }
        return responsibility;
    }

    private Citation createCitation(Identifier identifier) throws IOException {
        String title = this.stringValue("title");
        if (title == null && (title = this.stringValue("full_name")) == null && (title = this.stringValue("name")) == null) {
            title = this.decoder.getTitle();
        }
        Date creation = this.decoder.dateValue("date_created");
        Date modified = this.decoder.dateValue("date_modified");
        Date issued = this.decoder.dateValue("date_issued");
        String references = this.stringValue("references");
        DefaultCitation citation = new DefaultCitation((CharSequence)title);
        if (identifier != null) {
            citation.setIdentifiers(Collections.singleton(identifier));
        }
        if (creation != null) {
            citation.setDates(Collections.singleton(new DefaultCitationDate(creation, DateType.CREATION)));
        }
        if (modified != null) {
            citation.getDates().add(new DefaultCitationDate(modified, DateType.REVISION));
        }
        if (issued != null) {
            citation.getDates().add(new DefaultCitationDate(issued, DateType.PUBLICATION));
        }
        if (this.pointOfContact != null) {
            DefaultResponsibleParty np = new DefaultResponsibleParty(this.pointOfContact);
            np.setRole(Role.ORIGINATOR);
            citation.setCitedResponsibleParties(Collections.singleton(np));
        }
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            ResponsibleParty contributor = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (contributor == null || contributor == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(citation.getCitedResponsibleParties(), contributor);
        }
        this.decoder.setSearchPath(this.searchPath);
        if (references != null) {
            citation.setOtherCitationDetails((InternationalString)new SimpleInternationalString(references));
        }
        return citation.isEmpty() ? null : citation;
    }

    private DataIdentification createIdentificationInfo(Identifier identifier, Set<InternationalString> publisher) throws IOException {
        DefaultDataIdentification identification = null;
        Set<InternationalString> project = null;
        DefaultLegalConstraints constraints = null;
        boolean hasExtent = false;
        for (String path : this.searchPath) {
            Extent extent;
            this.decoder.setSearchPath(path);
            Keywords standard = this.createKeywords(KeywordType.THEME, true);
            Keywords keywords = this.createKeywords(KeywordType.THEME, false);
            String topic = this.stringValue("topic_category");
            String type = this.stringValue("cdm_data_type");
            String credits = this.stringValue("acknowledgment");
            String license = this.stringValue("license");
            String access = this.stringValue("acces_constraint");
            Extent extent2 = extent = hasExtent ? null : this.createExtent();
            if (standard != null || keywords != null || topic != null || type != null || credits != null || license != null || access != null || extent != null) {
                if (identification == null) {
                    identification = new DefaultDataIdentification();
                }
                if (topic != null) {
                    MetadataReader.addIfAbsent(identification.getTopicCategories(), this.forCodeName(TopicCategory.class, topic));
                }
                if (type != null) {
                    MetadataReader.addIfAbsent(identification.getSpatialRepresentationTypes(), this.forCodeName(SpatialRepresentationType.class, type));
                }
                if (standard != null) {
                    MetadataReader.addIfAbsent(identification.getDescriptiveKeywords(), standard);
                }
                if (keywords != null) {
                    MetadataReader.addIfAbsent(identification.getDescriptiveKeywords(), keywords);
                }
                if (credits != null) {
                    MetadataReader.addIfAbsent(identification.getCredits(), credits);
                }
                if (license != null) {
                    constraints = new DefaultLegalConstraints((CharSequence)license);
                    MetadataReader.addIfAbsent(identification.getResourceConstraints(), constraints);
                }
                if (access != null) {
                    for (String keyword : access.split(KEYWORD_SEPARATOR)) {
                        if ((keyword = keyword.trim()).isEmpty()) continue;
                        if (constraints == null) {
                            constraints = new DefaultLegalConstraints();
                            identification.getResourceConstraints().add(constraints);
                        }
                        MetadataReader.addIfAbsent(constraints.getAccessConstraints(), this.forCodeName(Restriction.class, keyword));
                    }
                }
                if (extent != null) {
                    identification.setExtents(Collections.singleton(extent));
                    hasExtent = true;
                }
            }
            project = MetadataReader.addIfNonNull(project, MetadataReader.toInternationalString(this.stringValue("project")));
        }
        this.decoder.setSearchPath(this.searchPath);
        Citation citation = this.createCitation(identifier);
        String summary = this.stringValue("summary");
        String purpose = this.stringValue("purpose");
        if (identification == null) {
            if (citation == null && summary == null && purpose == null && project == null && publisher == null && this.pointOfContact == null) {
                return null;
            }
            identification = new DefaultDataIdentification();
        }
        identification.setCitation(citation);
        identification.setAbstract(MetadataReader.toInternationalString(summary));
        identification.setPurpose(MetadataReader.toInternationalString(purpose));
        if (this.pointOfContact != null) {
            identification.setPointOfContacts(Collections.singleton(this.pointOfContact));
        }
        this.addKeywords(identification, project, KeywordType.valueOf((String)"project"));
        this.addKeywords(identification, publisher, KeywordType.valueOf((String)"dataCentre"));
        identification.setSupplementalInformation(MetadataReader.toInternationalString(this.stringValue("comment")));
        return identification;
    }

    private void addKeywords(DefaultDataIdentification addTo, Set<InternationalString> words, KeywordType type) {
        if (words != null) {
            DefaultKeywords keywords = new DefaultKeywords();
            keywords.setKeywords(words);
            keywords.setType(type);
            addTo.getDescriptiveKeywords().add(keywords);
        }
    }

    private Keywords createKeywords(KeywordType type, boolean standard) throws IOException {
        String list = this.stringValue(standard ? "standard_name" : "keywords");
        DefaultKeywords keywords = null;
        if (list != null) {
            LinkedHashSet<SimpleInternationalString> words = new LinkedHashSet<SimpleInternationalString>();
            for (String keyword : list.split(KEYWORD_SEPARATOR)) {
                if ((keyword = keyword.trim()).isEmpty()) continue;
                words.add(new SimpleInternationalString(keyword));
            }
            if (!words.isEmpty()) {
                keywords = new DefaultKeywords();
                keywords.setKeywords(words);
                keywords.setType(type);
                String vocabulary = this.stringValue(standard ? "standard_name_vocabulary" : "keywords_vocabulary");
                if (vocabulary != null) {
                    keywords.setThesaurusName((Citation)new DefaultCitation((CharSequence)vocabulary));
                }
            }
        }
        return keywords;
    }

    private GridSpatialRepresentation createSpatialRepresentationInfo(GridGeometry cs) throws IOException {
        DefaultGridSpatialRepresentation grid = new DefaultGridSpatialRepresentation();
        grid.setNumberOfDimensions(Integer.valueOf(cs.getTargetDimensions()));
        Axis[] axes = cs.getAxes();
        int i = axes.length;
        while (--i >= 0) {
            Axis axis = axes[i];
            if (axis.sourceDimensions.length == 0) continue;
            DefaultDimension dimension = new DefaultDimension();
            dimension.setDimensionSize(Integer.valueOf(axis.sourceSizes[0]));
            AttributeNames.Dimension attributeNames = axis.attributeNames;
            if (attributeNames != null) {
                dimension.setDimensionName(attributeNames.DEFAULT_NAME_TYPE);
                Number value = this.decoder.numericValue(attributeNames.RESOLUTION);
                if (value != null) {
                    dimension.setResolution(Double.valueOf(value instanceof Double ? ((Double)value).doubleValue() : value.doubleValue()));
                }
            }
            grid.getAxisDimensionProperties().add(dimension);
        }
        grid.setCellGeometry(CellGeometry.AREA);
        return grid;
    }

    private Extent createExtent() throws IOException {
        String identifier;
        DefaultExtent extent = null;
        Number xmin = this.decoder.numericValue(AttributeNames.LONGITUDE.MINIMUM);
        Number xmax = this.decoder.numericValue(AttributeNames.LONGITUDE.MAXIMUM);
        Number ymin = this.decoder.numericValue(AttributeNames.LATITUDE.MINIMUM);
        Number ymax = this.decoder.numericValue(AttributeNames.LATITUDE.MAXIMUM);
        Number zmin = this.decoder.numericValue(AttributeNames.VERTICAL.MINIMUM);
        Number zmax = this.decoder.numericValue(AttributeNames.VERTICAL.MAXIMUM);
        if (xmin != null || xmax != null || ymin != null || ymax != null) {
            UnitConverter xConv = this.getConverterTo(this.decoder.unitValue(AttributeNames.LONGITUDE.UNITS), NonSI.DEGREE_ANGLE);
            UnitConverter yConv = this.getConverterTo(this.decoder.unitValue(AttributeNames.LATITUDE.UNITS), NonSI.DEGREE_ANGLE);
            extent = new DefaultExtent(null, (GeographicExtent)new DefaultGeographicBoundingBox(MetadataReader.valueOf(xmin, xConv), MetadataReader.valueOf(xmax, xConv), MetadataReader.valueOf(ymin, yConv), MetadataReader.valueOf(ymax, yConv)), null, null);
        }
        if (zmin != null || zmax != null) {
            UnitConverter c = this.getConverterTo(this.decoder.unitValue(AttributeNames.VERTICAL.UNITS), (Unit<?>)SI.METRE);
            double min = MetadataReader.valueOf(zmin, c);
            double max = MetadataReader.valueOf(zmax, c);
            if ("down".equals(this.stringValue(AttributeNames.VERTICAL.POSITIVE))) {
                double tmp = min;
                min = -max;
                max = -tmp;
            }
            if (extent == null) {
                extent = new DefaultExtent();
            }
            extent.setVerticalElements(Collections.singleton(new DefaultVerticalExtent(min, max, VERTICAL_CRS)));
        }
        Date startTime = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        Date endTime = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (startTime == null && endTime == null) {
            String symbol;
            Number tmin = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number tmax = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((tmin != null || tmax != null) && (symbol = this.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dates = this.decoder.numberToDate(symbol, tmin, tmax);
                startTime = dates[0];
                endTime = dates[1];
            }
        }
        if (startTime != null || endTime != null) {
            try {
                DefaultTemporalExtent t = new DefaultTemporalExtent();
                t.setBounds(startTime, endTime);
                if (extent == null) {
                    extent = new DefaultExtent();
                }
                extent.setTemporalElements(Collections.singleton(t));
            }
            catch (UnsupportedOperationException e) {
                this.warning(e);
            }
        }
        if ((identifier = this.stringValue("geographic_identifier")) != null) {
            if (extent == null) {
                extent = new DefaultExtent();
            }
            extent.setGeographicElements(Collections.singleton(new DefaultGeographicDescription((CharSequence)identifier)));
        }
        return extent;
    }

    private UnitConverter getConverterTo(Unit<?> source, Unit<?> target) {
        if (source != null) {
            try {
                return source.getConverterToAny(target);
            }
            catch (ConversionException e) {
                this.warning((Exception)((Object)e));
            }
        }
        return null;
    }

    private static double valueOf(Number value, UnitConverter converter) {
        double n = Double.NaN;
        if (value != null) {
            n = value.doubleValue();
            if (converter != null) {
                n = converter.convert(n);
            }
        }
        return n;
    }

    private Collection<DefaultCoverageDescription> createContentInfo() throws IOException {
        HashMap<List<String>, DefaultCoverageDescription> contents = new HashMap<List<String>, DefaultCoverageDescription>(4);
        String processingLevel = this.stringValue("processing_level");
        for (Variable variable : this.decoder.getVariables()) {
            if (!variable.isCoverage(2)) continue;
            DefaultAttributeGroup group = null;
            List<String> dimensions = Arrays.asList(variable.getGridDimensionNames());
            DefaultCoverageDescription content = (DefaultCoverageDescription)contents.get(dimensions);
            if (content == null) {
                if (processingLevel != null) {
                    content = new DefaultImageDescription();
                    content.setProcessingLevelCode((Identifier)new DefaultIdentifier(processingLevel));
                } else {
                    content = new DefaultCoverageDescription();
                }
                contents.put(dimensions, content);
            } else {
                group = (DefaultAttributeGroup)CollectionsExt.first((Iterable)content.getAttributeGroups());
            }
            if (group == null) {
                group = new DefaultAttributeGroup();
                content.setAttributeGroups(Collections.singleton(group));
            }
            group.getAttributes().add(this.createSampleDimension(variable));
            Object[] names = variable.getAttributeValues("flag_names", false);
            Object[] meanings = variable.getAttributeValues("flag_meanings", false);
            Object[] masks = variable.getAttributeValues("flag_masks", true);
            Object[] values = variable.getAttributeValues("flag_values", true);
            int length = Math.max(masks.length, Math.max(values.length, Math.max(names.length, meanings.length)));
            for (int i = 0; i < length; ++i) {
                RangeElementDescription element = this.createRangeElementDescription(variable, i < names.length ? (String)names[i] : null, i < meanings.length ? (String)meanings[i] : null, i < masks.length ? (Number)((Number)masks[i]) : (Number)null, i < values.length ? (Number)((Number)values[i]) : (Number)null);
                if (element == null) continue;
                content.getRangeElementDescriptions().add(element);
            }
        }
        return contents.values();
    }

    private Band createSampleDimension(Variable variable) throws IOException {
        String units;
        String description;
        DefaultBand band = new DefaultBand();
        String name = variable.getName();
        if (name != null && !(name = name.trim()).isEmpty()) {
            if (this.nameFactory == null) {
                this.nameFactory = (DefaultNameFactory)DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            }
            band.setSequenceIdentifier(this.nameFactory.createMemberName(null, (CharSequence)name, this.nameFactory.createTypeName(null, (CharSequence)variable.getDataTypeName())));
        }
        if ((description = variable.getDescription()) != null && !(description = description.trim()).isEmpty() && !description.equals(name)) {
            band.setDescription((InternationalString)new SimpleInternationalString(description));
        }
        if ((units = variable.getUnitsString()) != null) {
            try {
                band.setUnits(Units.valueOf((String)units));
            }
            catch (RuntimeException e) {
                this.decoder.listeners.warning(this.errors().getString((short)168, (Object)name, (Object)units), (Exception)e);
            }
        }
        return band;
    }

    private RangeElementDescription createRangeElementDescription(Variable variable, String name, String meaning, Number mask, Number value) throws IOException {
        if (name != null && meaning != null) {
            DefaultRangeElementDescription element = new DefaultRangeElementDescription();
            element.setName((InternationalString)new SimpleInternationalString(name));
            element.setDefinition((InternationalString)new SimpleInternationalString(meaning));
            return element;
        }
        return null;
    }

    private Identifier getFileIdentifier() throws IOException {
        String identifier = this.stringValue("id");
        if (identifier == null && (identifier = this.decoder.getId()) == null) {
            return null;
        }
        String namespace = this.stringValue("naming_authority");
        return new DefaultIdentifier((Citation)(namespace != null ? new DefaultCitation((CharSequence)namespace) : null), identifier);
    }

    public Metadata read() throws IOException {
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.setMetadataStandards((Collection)Citations.ISO_19115);
        Identifier identifier = this.getFileIdentifier();
        metadata.setMetadataIdentifier(identifier);
        Date creation = this.decoder.dateValue("metadata_creation");
        if (creation != null) {
            metadata.setDateInfo(Collections.singleton(new DefaultCitationDate(creation, DateType.CREATION)));
        }
        metadata.setMetadataScopes(Collections.singleton(new DefaultMetadataScope(ScopeCode.DATASET, null)));
        for (String service : SERVICES) {
            String name = this.stringValue(service);
            if (name == null) continue;
            MetadataReader.addIfAbsent(metadata.getMetadataScopes(), new DefaultMetadataScope(ScopeCode.SERVICE, (CharSequence)name));
        }
        for (String path : this.searchPath) {
            this.decoder.setSearchPath(path);
            ResponsibleParty party = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (party == null || party == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(metadata.getContacts(), party);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = party;
        }
        Set<InternationalString> publisher = null;
        DefaultDistribution distribution = null;
        for (String path : this.searchPath) {
            String history;
            this.decoder.setSearchPath(path);
            ResponsibleParty r = this.createResponsibleParty(AttributeNames.PUBLISHER, false);
            if (r != null) {
                if (distribution == null) {
                    distribution = new DefaultDistribution();
                    metadata.setDistributionInfo((Distribution)distribution);
                }
                DefaultDistributor distributor = new DefaultDistributor(r);
                MetadataReader.addIfAbsent(distribution.getDistributors(), distributor);
                publisher = MetadataReader.addIfNonNull(publisher, r.getOrganisationName());
                publisher = MetadataReader.addIfNonNull(publisher, MetadataReader.toInternationalString(r.getIndividualName()));
            }
            if ((history = this.stringValue("history")) == null) continue;
            DefaultDataQuality quality = new DefaultDataQuality();
            DefaultLineage lineage = new DefaultLineage();
            lineage.setStatement((InternationalString)new SimpleInternationalString(history));
            quality.setLineage((Lineage)lineage);
            MetadataReader.addIfAbsent(metadata.getDataQualityInfo(), quality);
        }
        DataIdentification identification = this.createIdentificationInfo(identifier, publisher);
        if (identification != null) {
            metadata.setIdentificationInfo(Collections.singleton(identification));
        }
        metadata.setContentInfo(this.createContentInfo());
        for (GridGeometry cs : this.decoder.getGridGeometries()) {
            if (cs.getSourceDimensions() < 2 || cs.getTargetDimensions() < 2) continue;
            metadata.getSpatialRepresentationInfo().add(this.createSpatialRepresentationInfo(cs));
        }
        return metadata;
    }
}

