/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.lang.reflect.Array;
import org.apache.sis.internal.jdk8.Function;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Utilities;

final class Attribute {
    static final Function<Attribute, String> NAME_FUNCTION = new Function<Attribute, String>(){

        public String apply(Attribute value) {
            return value.name;
        }
    };
    final String name;
    final Object value;

    Attribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    final String[] stringValues() {
        if (this.value instanceof String) {
            return new String[]{(String)this.value};
        }
        String[] values = new String[Array.getLength(this.value)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Array.get(this.value, i).toString();
        }
        return values;
    }

    final Number[] numberValues() {
        Number[] values = new Number[this.value instanceof String ? 0 : Array.getLength(this.value)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Number)Array.get(this.value, i);
        }
        return values;
    }

    final boolean booleanValue() {
        return this.value instanceof String && Boolean.valueOf((String)this.value) != false;
    }

    static String dateToISO(String date) {
        if ((date = CharSequences.trimWhitespaces((String)date)) != null && !date.isEmpty()) {
            boolean hasTimeZone;
            int timeFieldStart = date.lastIndexOf(84) + 1;
            int timeFieldEnd = date.length();
            int missingFields = 2;
            boolean bl = hasTimeZone = date.charAt(timeFieldEnd - 1) == 'Z';
            if (timeFieldStart != 0) {
                if (hasTimeZone) {
                    --timeFieldEnd;
                } else {
                    int s = Math.max(date.indexOf(43, timeFieldStart), date.indexOf(45, timeFieldStart));
                    hasTimeZone = s >= 0;
                    if (hasTimeZone) {
                        timeFieldEnd = s;
                    }
                }
                for (int i = timeFieldStart; i < timeFieldEnd && (date.charAt(i) != ':' || --missingFields != 0); ++i) {
                }
            }
            CharSequence modified = date;
            if (missingFields != 0 || !hasTimeZone) {
                StringBuilder buffer = new StringBuilder(date);
                buffer.setLength(timeFieldEnd);
                if (timeFieldStart == 0) {
                    buffer.append("T00");
                }
                while (--missingFields >= 0) {
                    buffer.append(":00");
                }
                if (hasTimeZone) {
                    buffer.append(date, timeFieldEnd, date.length());
                } else {
                    buffer.append('Z');
                }
                modified = buffer;
            }
            int indexOfLastDigit = 0;
            int i = modified.length();
            while (--i >= 0) {
                boolean isDigit;
                char c = modified.charAt(i);
                boolean bl2 = isDigit = c >= '0' && c <= '9';
                if (indexOfLastDigit == 0) {
                    if (!isDigit) continue;
                    indexOfLastDigit = i;
                    continue;
                }
                if (isDigit) continue;
                if (indexOfLastDigit - i == 1) {
                    StringBuilder buffer;
                    if (modified == date) {
                        buffer = new StringBuilder(date);
                        modified = buffer;
                    } else {
                        buffer = (StringBuilder)modified;
                    }
                    buffer.insert(i + 1, '0');
                }
                indexOfLastDigit = 0;
            }
            date = modified.toString();
        }
        return date;
    }

    public String toString() {
        return this.name + " = " + Utilities.deepToString((Object)this.value);
    }
}

