/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.metadata.iso.citation.DefaultAddress;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultContact;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.citation.DefaultResponsibleParty;
import org.apache.sis.metadata.iso.constraint.DefaultLegalConstraints;
import org.apache.sis.metadata.iso.content.DefaultBand;
import org.apache.sis.metadata.iso.content.DefaultCoverageDescription;
import org.apache.sis.metadata.iso.content.DefaultImageDescription;
import org.apache.sis.metadata.iso.content.DefaultRangeElementDescription;
import org.apache.sis.metadata.iso.distribution.DefaultDistribution;
import org.apache.sis.metadata.iso.distribution.DefaultDistributor;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultGeographicDescription;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.iso.lineage.DefaultLineage;
import org.apache.sis.metadata.iso.quality.DefaultDataQuality;
import org.apache.sis.metadata.iso.spatial.DefaultDimension;
import org.apache.sis.metadata.iso.spatial.DefaultGridSpatialRepresentation;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.constraint.Restriction;
import org.opengis.metadata.content.Band;
import org.opengis.metadata.content.RangeElementDescription;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.KeywordType;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.GridSpatialRepresentation;
import org.opengis.metadata.spatial.SpatialRepresentationType;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.InternationalString;

final class MetadataReader {
    private static final String[] SEARCH_PATH = new String[]{"NCISOMetadata", "CFMetadata", null, "THREDDSMetadata"};
    private static final String KEYWORD_SEPARATOR = ",";
    private static final VerticalCRS VERTICAL_CRS = null;
    private final Decoder decoder;
    private final String[] searchPath;
    private transient DefaultNameFactory nameFactory;
    private transient ResponsibleParty pointOfContact;

    MetadataReader(Decoder decoder) throws IOException {
        this.decoder = decoder;
        decoder.setSearchPath(SEARCH_PATH);
        this.searchPath = decoder.getSearchPath();
    }

    private static InternationalString toInternationalString(String string) {
        return string != null ? new SimpleInternationalString(string) : null;
    }

    private static <T> void addIfAbsent(Collection<T> collection, T t) {
        if (!collection.contains(t)) {
            collection.add(t);
        }
    }

    private static <T> Set<T> addIfNonNull(Set<T> set, T t) {
        if (t != null) {
            if (set == null) {
                set = new LinkedHashSet<T>(4);
            }
            set.add(t);
        }
        return set;
    }

    private static boolean isDefined(CharSequence charSequence, String string) {
        return string == null || charSequence != null && ((Object)charSequence).toString().equals(string);
    }

    private static boolean isDefined(Collection<String> collection, String string) {
        return string == null || collection.contains(string);
    }

    private static boolean isDefined(OnlineResource onlineResource, String string) {
        return string == null || onlineResource != null && MetadataReader.isDefined(onlineResource.getLinkage().toString(), string);
    }

    private static boolean isDefined(Address address, String string) {
        return string == null || address != null && MetadataReader.isDefined(address.getElectronicMailAddresses(), string);
    }

    private OnlineResource createOnlineResource(String string) {
        if (string != null) {
            try {
                DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource(new URI(string));
                defaultOnlineResource.setProtocol("http");
                defaultOnlineResource.setApplicationProfile("web browser");
                defaultOnlineResource.setFunction(OnLineFunction.INFORMATION);
                return defaultOnlineResource;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.decoder.listeners.warning(null, (Exception)uRISyntaxException);
            }
        }
        return null;
    }

    private static Address createAddress(String string) {
        if (string != null) {
            DefaultAddress defaultAddress = new DefaultAddress();
            defaultAddress.getElectronicMailAddresses().add(string);
            return defaultAddress;
        }
        return null;
    }

    private static Contact createContact(Address address, OnlineResource onlineResource) {
        if (address != null || onlineResource != null) {
            DefaultContact defaultContact = new DefaultContact();
            defaultContact.setAddress(address);
            defaultContact.setOnlineResource(onlineResource);
            return defaultContact;
        }
        return null;
    }

    private Identifier getFileIdentifier() throws IOException {
        String string = this.decoder.stringValue("id");
        if (string == null && (string = this.decoder.getId()) == null) {
            return null;
        }
        String string2 = this.decoder.stringValue("naming_authority");
        return new DefaultIdentifier((Citation)(string2 != null ? new DefaultCitation((CharSequence)string2) : null), string);
    }

    private ResponsibleParty createResponsibleParty(AttributeNames.Responsible responsible, boolean bl) throws IOException {
        String string = this.decoder.stringValue(responsible.NAME);
        String string2 = this.decoder.stringValue(responsible.INSTITUTION);
        String string3 = this.decoder.stringValue(responsible.EMAIL);
        String string4 = this.decoder.stringValue(responsible.URL);
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return null;
        }
        Role role = (Role)Types.forCodeName(Role.class, (String)this.decoder.stringValue(responsible.ROLE), (boolean)true);
        if (role == null) {
            role = bl ? Role.POINT_OF_CONTACT : responsible.DEFAULT_ROLE;
        }
        ResponsibleParty responsibleParty = this.pointOfContact;
        Contact contact = null;
        Address address = null;
        OnlineResource onlineResource = null;
        if (responsibleParty != null) {
            contact = responsibleParty.getContactInfo();
            if (contact != null) {
                address = contact.getAddress();
                onlineResource = contact.getOnlineResource();
            }
            if (!MetadataReader.isDefined(onlineResource, string4)) {
                onlineResource = null;
                contact = null;
                responsibleParty = null;
            }
            if (!MetadataReader.isDefined(address, string3)) {
                address = null;
                contact = null;
                responsibleParty = null;
            }
            if (!(responsibleParty == null || MetadataReader.isDefined((CharSequence)responsibleParty.getOrganisationName(), string2) && MetadataReader.isDefined(responsibleParty.getIndividualName(), string))) {
                responsibleParty = null;
            }
        }
        if (responsibleParty == null) {
            if (contact == null) {
                if (address == null) {
                    address = MetadataReader.createAddress(string3);
                }
                if (onlineResource == null) {
                    onlineResource = this.createOnlineResource(string4);
                }
                contact = MetadataReader.createContact(address, onlineResource);
            }
            if (string != null || string2 != null || contact != null) {
                DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(role);
                defaultResponsibleParty.setIndividualName(string);
                defaultResponsibleParty.setOrganisationName(MetadataReader.toInternationalString(string2));
                defaultResponsibleParty.setContactInfo(contact);
                responsibleParty = defaultResponsibleParty;
            }
        }
        return responsibleParty;
    }

    private Citation createCitation(Identifier identifier) throws IOException {
        String string = this.decoder.stringValue("title");
        if (string == null && (string = this.decoder.stringValue("full_name")) == null && (string = this.decoder.stringValue("name")) == null) {
            string = this.decoder.getTitle();
        }
        Date date = this.decoder.dateValue("date_created");
        Date date2 = this.decoder.dateValue("date_modified");
        Date date3 = this.decoder.dateValue("date_issued");
        String string2 = this.decoder.stringValue("references");
        DefaultCitation defaultCitation = new DefaultCitation((CharSequence)string);
        if (identifier != null) {
            defaultCitation.getIdentifiers().add(identifier);
        }
        if (date != null) {
            defaultCitation.getDates().add(new DefaultCitationDate(date, DateType.CREATION));
        }
        if (date2 != null) {
            defaultCitation.getDates().add(new DefaultCitationDate(date2, DateType.REVISION));
        }
        if (date3 != null) {
            defaultCitation.getDates().add(new DefaultCitationDate(date3, DateType.PUBLICATION));
        }
        if (this.pointOfContact != null) {
            DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.ORIGINATOR);
            defaultResponsibleParty.setIndividualName(this.pointOfContact.getIndividualName());
            defaultResponsibleParty.setOrganisationName(this.pointOfContact.getOrganisationName());
            defaultResponsibleParty.setContactInfo(this.pointOfContact.getContactInfo());
            defaultCitation.getCitedResponsibleParties().add(defaultResponsibleParty);
        }
        for (DefaultResponsibleParty defaultResponsibleParty : this.searchPath) {
            this.decoder.setSearchPath(new String[]{defaultResponsibleParty});
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.CONTRIBUTOR, false);
            if (responsibleParty == null || responsibleParty == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(defaultCitation.getCitedResponsibleParties(), responsibleParty);
        }
        this.decoder.setSearchPath(this.searchPath);
        defaultCitation.setOtherCitationDetails(MetadataReader.toInternationalString(string2));
        return defaultCitation.isEmpty() ? null : defaultCitation;
    }

    private DataIdentification createIdentificationInfo(Identifier identifier, Set<InternationalString> set) throws IOException {
        DefaultDataIdentification defaultDataIdentification = null;
        Set<InternationalString> set2 = null;
        DefaultLegalConstraints defaultLegalConstraints = null;
        boolean bl = false;
        for (String string : this.searchPath) {
            Extent extent;
            this.decoder.setSearchPath(string);
            Keywords keywords = this.createKeywords(KeywordType.THEME, true);
            Keywords keywords2 = this.createKeywords(KeywordType.THEME, false);
            String string2 = this.decoder.stringValue("topic_category");
            String string3 = this.decoder.stringValue("cdm_data_type");
            String string4 = this.decoder.stringValue("acknowledgment");
            String string5 = this.decoder.stringValue("license");
            String string6 = this.decoder.stringValue("acces_constraint");
            Extent extent2 = extent = bl ? null : this.createExtent();
            if (keywords != null || keywords2 != null || string2 != null || string3 != null || string4 != null || string5 != null || string6 != null || extent != null) {
                if (defaultDataIdentification == null) {
                    defaultDataIdentification = new DefaultDataIdentification();
                }
                if (string2 != null) {
                    MetadataReader.addIfAbsent(defaultDataIdentification.getTopicCategories(), Types.forCodeName(TopicCategory.class, (String)string2, (boolean)true));
                }
                if (string3 != null) {
                    MetadataReader.addIfAbsent(defaultDataIdentification.getSpatialRepresentationTypes(), Types.forCodeName(SpatialRepresentationType.class, (String)string3, (boolean)true));
                }
                if (keywords != null) {
                    MetadataReader.addIfAbsent(defaultDataIdentification.getDescriptiveKeywords(), keywords);
                }
                if (keywords2 != null) {
                    MetadataReader.addIfAbsent(defaultDataIdentification.getDescriptiveKeywords(), keywords2);
                }
                if (string4 != null) {
                    MetadataReader.addIfAbsent(defaultDataIdentification.getCredits(), string4);
                }
                if (string5 != null) {
                    defaultLegalConstraints = new DefaultLegalConstraints((CharSequence)string5);
                    MetadataReader.addIfAbsent(defaultDataIdentification.getResourceConstraints(), defaultLegalConstraints);
                }
                if (string6 != null) {
                    for (String string7 : string6.split(KEYWORD_SEPARATOR)) {
                        if ((string7 = string7.trim()).isEmpty()) continue;
                        if (defaultLegalConstraints == null) {
                            defaultLegalConstraints = new DefaultLegalConstraints();
                            defaultDataIdentification.getResourceConstraints().add(defaultLegalConstraints);
                        }
                        MetadataReader.addIfAbsent(defaultLegalConstraints.getAccessConstraints(), Types.forCodeName(Restriction.class, (String)string7, (boolean)true));
                    }
                }
                if (extent != null) {
                    defaultDataIdentification.getExtents().add(extent);
                    bl = true;
                }
            }
            set2 = MetadataReader.addIfNonNull(set2, MetadataReader.toInternationalString(this.decoder.stringValue("project")));
        }
        this.decoder.setSearchPath(this.searchPath);
        Citation citation = this.createCitation(identifier);
        String string = this.decoder.stringValue("summary");
        String string8 = this.decoder.stringValue("purpose");
        if (defaultDataIdentification == null) {
            if (citation == null && string == null && string8 == null && set2 == null && set == null && this.pointOfContact == null) {
                return null;
            }
            defaultDataIdentification = new DefaultDataIdentification();
        }
        defaultDataIdentification.setCitation(citation);
        defaultDataIdentification.setAbstract(MetadataReader.toInternationalString(string));
        defaultDataIdentification.setPurpose(MetadataReader.toInternationalString(string8));
        if (this.pointOfContact != null) {
            defaultDataIdentification.getPointOfContacts().add(this.pointOfContact);
        }
        MetadataReader.addKeywords(defaultDataIdentification, set2, "project");
        MetadataReader.addKeywords(defaultDataIdentification, set, "dataCenter");
        defaultDataIdentification.setSupplementalInformation(MetadataReader.toInternationalString(this.decoder.stringValue("comment")));
        return defaultDataIdentification;
    }

    private static void addKeywords(DefaultDataIdentification defaultDataIdentification, Set<InternationalString> set, String string) {
        if (set != null) {
            DefaultKeywords defaultKeywords = new DefaultKeywords();
            defaultKeywords.setKeywords(set);
            defaultKeywords.setType((KeywordType)Types.forCodeName(KeywordType.class, (String)string, (boolean)true));
            defaultDataIdentification.getDescriptiveKeywords().add(defaultKeywords);
        }
    }

    private Keywords createKeywords(KeywordType keywordType, boolean bl) throws IOException {
        String string = this.decoder.stringValue(bl ? "standard_name" : "keywords");
        DefaultKeywords defaultKeywords = null;
        if (string != null) {
            LinkedHashSet<SimpleInternationalString> linkedHashSet = new LinkedHashSet<SimpleInternationalString>();
            for (String string2 : string.split(KEYWORD_SEPARATOR)) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                linkedHashSet.add(new SimpleInternationalString(string2));
            }
            if (!linkedHashSet.isEmpty()) {
                defaultKeywords = new DefaultKeywords();
                defaultKeywords.setKeywords(linkedHashSet);
                defaultKeywords.setType(keywordType);
                String string3 = this.decoder.stringValue(bl ? "standard_name_vocabulary" : "keywords_vocabulary");
                if (string3 != null) {
                    defaultKeywords.setThesaurusName((Citation)new DefaultCitation((CharSequence)string3));
                }
            }
        }
        return defaultKeywords;
    }

    private GridSpatialRepresentation createSpatialRepresentationInfo(GridGeometry gridGeometry) throws IOException {
        DefaultGridSpatialRepresentation defaultGridSpatialRepresentation = new DefaultGridSpatialRepresentation();
        defaultGridSpatialRepresentation.setNumberOfDimensions(Integer.valueOf(gridGeometry.getTargetDimensions()));
        Axis[] axisArray = gridGeometry.getAxes();
        int n = axisArray.length;
        while (--n >= 0) {
            Axis axis = axisArray[n];
            if (axis.sourceDimensions.length == 0) continue;
            DefaultDimension defaultDimension = new DefaultDimension();
            defaultDimension.setDimensionSize(Integer.valueOf(axis.sourceSizes[0]));
            AttributeNames.Dimension dimension = axis.attributeNames;
            if (dimension != null) {
                defaultDimension.setDimensionName(dimension.DEFAULT_NAME_TYPE);
                Number number = this.decoder.numericValue(dimension.RESOLUTION);
                if (number != null) {
                    defaultDimension.setResolution(Double.valueOf(number instanceof Double ? ((Double)number).doubleValue() : number.doubleValue()));
                }
            }
            defaultGridSpatialRepresentation.getAxisDimensionProperties().add(defaultDimension);
        }
        defaultGridSpatialRepresentation.setCellGeometry(CellGeometry.AREA);
        return defaultGridSpatialRepresentation;
    }

    private Extent createExtent() throws IOException {
        Object object;
        Object object2;
        Object object3;
        DefaultExtent defaultExtent = null;
        Number number = this.decoder.numericValue(AttributeNames.LONGITUDE.MINIMUM);
        Number number2 = this.decoder.numericValue(AttributeNames.LONGITUDE.MAXIMUM);
        Number number3 = this.decoder.numericValue(AttributeNames.LATITUDE.MINIMUM);
        Number number4 = this.decoder.numericValue(AttributeNames.LATITUDE.MAXIMUM);
        Number number5 = this.decoder.numericValue(AttributeNames.VERTICAL.MINIMUM);
        Number number6 = this.decoder.numericValue(AttributeNames.VERTICAL.MAXIMUM);
        if (number != null || number2 != null || number3 != null || number4 != null) {
            object3 = this.getConverterTo(this.decoder.unitValue(AttributeNames.LONGITUDE.UNITS), NonSI.DEGREE_ANGLE);
            object2 = this.getConverterTo(this.decoder.unitValue(AttributeNames.LATITUDE.UNITS), NonSI.DEGREE_ANGLE);
            defaultExtent = new DefaultExtent(null, (GeographicExtent)new DefaultGeographicBoundingBox(MetadataReader.valueOf(number, object3), MetadataReader.valueOf(number2, object3), MetadataReader.valueOf(number3, object2), MetadataReader.valueOf(number4, object2)), null, null);
        }
        if (number5 != null || number6 != null) {
            object3 = this.getConverterTo(this.decoder.unitValue(AttributeNames.VERTICAL.UNITS), (Unit<?>)SI.METRE);
            double d = MetadataReader.valueOf(number5, object3);
            double d2 = MetadataReader.valueOf(number6, object3);
            if ("down".equals(this.decoder.stringValue(AttributeNames.VERTICAL.POSITIVE))) {
                double d3 = d;
                d = -d2;
                d2 = -d3;
            }
            if (defaultExtent == null) {
                defaultExtent = new DefaultExtent();
            }
            defaultExtent.getVerticalElements().add(new DefaultVerticalExtent(d, d2, VERTICAL_CRS));
        }
        object3 = this.decoder.dateValue(AttributeNames.TIME.MINIMUM);
        object2 = this.decoder.dateValue(AttributeNames.TIME.MAXIMUM);
        if (object3 == null && object2 == null) {
            String string;
            object = this.decoder.numericValue(AttributeNames.TIME.MINIMUM);
            Number number7 = this.decoder.numericValue(AttributeNames.TIME.MAXIMUM);
            if ((object != null || number7 != null) && (string = this.decoder.stringValue(AttributeNames.TIME.UNITS)) != null) {
                Date[] dateArray = this.decoder.numberToDate(string, new Number[]{object, number7});
                object3 = dateArray[0];
                object2 = dateArray[1];
            }
        }
        if (object3 != null || object2 != null) {
            try {
                object = new DefaultTemporalExtent();
                object.setBounds((Date)object3, (Date)object2);
                if (defaultExtent == null) {
                    defaultExtent = new DefaultExtent();
                }
                defaultExtent.getTemporalElements().add(object);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.decoder.listeners.warning(null, (Exception)unsupportedOperationException);
            }
        }
        if ((object = this.decoder.stringValue("geographic_identifier")) != null) {
            if (defaultExtent == null) {
                defaultExtent = new DefaultExtent();
            }
            defaultExtent.getGeographicElements().add(new DefaultGeographicDescription(null, (String)object));
        }
        return defaultExtent;
    }

    private UnitConverter getConverterTo(Unit<?> unit, Unit<?> unit2) {
        if (unit != null) {
            try {
                return unit.getConverterToAny(unit2);
            }
            catch (ConversionException conversionException) {
                this.decoder.listeners.warning(null, (Exception)((Object)conversionException));
            }
        }
        return null;
    }

    private static double valueOf(Number number, UnitConverter unitConverter) {
        double d = Double.NaN;
        if (number != null) {
            d = number.doubleValue();
            if (unitConverter != null) {
                d = unitConverter.convert(d);
            }
        }
        return d;
    }

    private Collection<DefaultCoverageDescription> createContentInfo() throws IOException {
        HashMap<List<String>, DefaultCoverageDescription> hashMap = new HashMap<List<String>, DefaultCoverageDescription>(4);
        String string = this.decoder.stringValue("processing_level");
        for (Variable variable : this.decoder.getVariables()) {
            if (!variable.isCoverage(2)) continue;
            List<String> list = Arrays.asList(variable.getGridDimensionNames());
            DefaultCoverageDescription defaultCoverageDescription = (DefaultCoverageDescription)hashMap.get(list);
            if (defaultCoverageDescription == null) {
                if (string != null) {
                    defaultCoverageDescription = new DefaultImageDescription();
                    ((DefaultImageDescription)defaultCoverageDescription).setProcessingLevelCode((Identifier)new DefaultIdentifier(string));
                } else {
                    defaultCoverageDescription = new DefaultCoverageDescription();
                }
                hashMap.put(list, defaultCoverageDescription);
            }
            defaultCoverageDescription.getDimensions().add(this.createSampleDimension(variable));
            Object[] objectArray = variable.getAttributeValues("flag_names", false);
            Object[] objectArray2 = variable.getAttributeValues("flag_meanings", false);
            Object[] objectArray3 = variable.getAttributeValues("flag_masks", true);
            Object[] objectArray4 = variable.getAttributeValues("flag_values", true);
            int n = Math.max(objectArray3.length, Math.max(objectArray4.length, Math.max(objectArray.length, objectArray2.length)));
            for (int i = 0; i < n; ++i) {
                RangeElementDescription rangeElementDescription = this.createRangeElementDescription(variable, i < objectArray.length ? (String)objectArray[i] : null, i < objectArray2.length ? (String)objectArray2[i] : null, i < objectArray3.length ? (Number)((Number)objectArray3[i]) : (Number)null, i < objectArray4.length ? (Number)((Number)objectArray4[i]) : (Number)null);
                if (rangeElementDescription == null) continue;
                defaultCoverageDescription.getRangeElementDescriptions().add(rangeElementDescription);
            }
        }
        return hashMap.values();
    }

    private Band createSampleDimension(Variable variable) throws IOException {
        String string;
        DefaultBand defaultBand = new DefaultBand();
        String string2 = variable.getName();
        if (string2 != null && !(string2 = string2.trim()).isEmpty()) {
            if (this.nameFactory == null) {
                this.nameFactory = DefaultFactories.NAMES;
            }
            defaultBand.setSequenceIdentifier(this.nameFactory.createMemberName(null, (CharSequence)string2, this.nameFactory.createTypeName(null, (CharSequence)variable.getDataTypeName())));
        }
        if ((string = variable.getDescription()) != null && !(string = string.trim()).isEmpty() && !string.equals(string2)) {
            defaultBand.setDescriptor(MetadataReader.toInternationalString(string));
        }
        return defaultBand;
    }

    private RangeElementDescription createRangeElementDescription(Variable variable, String string, String string2, Number number, Number number2) throws IOException {
        if (string != null && string2 != null) {
            DefaultRangeElementDescription defaultRangeElementDescription = new DefaultRangeElementDescription();
            defaultRangeElementDescription.setName(MetadataReader.toInternationalString(string));
            defaultRangeElementDescription.setDefinition(MetadataReader.toInternationalString(string2));
            return defaultRangeElementDescription;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Metadata read() throws IOException {
        void var5_8;
        Object object2;
        String string;
        DefaultMetadata defaultMetadata = new DefaultMetadata();
        defaultMetadata.setMetadataStandardName("ISO 19115-2 Geographic Information - Metadata Part 2 Extensions for imagery and gridded data");
        defaultMetadata.setMetadataStandardVersion("ISO 19115-2:2009(E)");
        Identifier identifier = this.getFileIdentifier();
        if (identifier != null) {
            InternationalString object;
            string = identifier.getCode();
            object2 = identifier.getAuthority();
            if (object2 != null && (object = object2.getTitle()) != null) {
                string = object.toString() + ':' + string;
            }
            defaultMetadata.setFileIdentifier(string);
        }
        defaultMetadata.setDateStamp(this.decoder.dateValue("metadata_creation"));
        defaultMetadata.getHierarchyLevels().add(ScopeCode.DATASET);
        string = this.decoder.stringValue("wms_service");
        object2 = this.decoder.stringValue("wcs_service");
        if (string != null || object2 != null) {
            defaultMetadata.getHierarchyLevels().add(ScopeCode.SERVICE);
        }
        for (String string2 : this.searchPath) {
            this.decoder.setSearchPath(string2);
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.CREATOR, true);
            if (responsibleParty == null || responsibleParty == this.pointOfContact) continue;
            MetadataReader.addIfAbsent(defaultMetadata.getContacts(), responsibleParty);
            if (this.pointOfContact != null) continue;
            this.pointOfContact = responsibleParty;
        }
        Object var5_7 = null;
        DefaultDistribution defaultDistribution = null;
        for (String string3 : this.searchPath) {
            String string4;
            this.decoder.setSearchPath(string3);
            ResponsibleParty responsibleParty = this.createResponsibleParty(AttributeNames.PUBLISHER, false);
            if (responsibleParty != null) {
                if (defaultDistribution == null) {
                    defaultDistribution = new DefaultDistribution();
                    defaultMetadata.setDistributionInfo((Distribution)defaultDistribution);
                }
                string4 = new DefaultDistributor(responsibleParty);
                MetadataReader.addIfAbsent(defaultDistribution.getDistributors(), string4);
                Set<InternationalString> set = MetadataReader.addIfNonNull(var5_8, MetadataReader.toInternationalString(responsibleParty.getIndividualName()));
            }
            if ((string4 = this.decoder.stringValue("history")) == null) continue;
            DefaultDataQuality defaultDataQuality = new DefaultDataQuality();
            DefaultLineage defaultLineage = new DefaultLineage();
            defaultLineage.setStatement((InternationalString)new SimpleInternationalString(string4));
            defaultDataQuality.setLineage((Lineage)defaultLineage);
            MetadataReader.addIfAbsent(defaultMetadata.getDataQualityInfo(), defaultDataQuality);
        }
        DataIdentification dataIdentification = this.createIdentificationInfo(identifier, (Set<InternationalString>)var5_8);
        if (dataIdentification != null) {
            defaultMetadata.getIdentificationInfo().add(dataIdentification);
        }
        defaultMetadata.setContentInfo(this.createContentInfo());
        for (GridGeometry gridGeometry : this.decoder.getGridGeometries()) {
            if (gridGeometry.getSourceDimensions() < 2 || gridGeometry.getTargetDimensions() < 2) continue;
            defaultMetadata.getSpatialRepresentationInfo().add(this.createSpatialRepresentationInfo(gridGeometry));
        }
        defaultMetadata.freeze();
        return defaultMetadata;
    }
}

