/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.sirona.cube.Cube;
import org.apache.sirona.cube.CubeBuilder;

public class HttpClientCube
extends Cube {
    private static final Logger LOGGER = Logger.getLogger(HttpClientCube.class.getName());
    private HttpClient httpclient;
    private CloseableHttpAsyncClient closeableHttpAsyncClient;
    private RequestConfig requestConfig;

    public HttpClientCube(CubeBuilder cubeBuilder) {
        super(cubeBuilder);
        try {
            this.requestConfig = RequestConfig.custom().setSocketTimeout(cubeBuilder.getPostTimeout()).setConnectTimeout(cubeBuilder.getConnectionTimeout()).setConnectionRequestTimeout(cubeBuilder.getConnectionRequestTimeout()).build();
            if (cubeBuilder.isUseAsync()) {
                IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(cubeBuilder.getAsyncIoThreadCount()).setConnectTimeout(cubeBuilder.getConnectionTimeout()).setSoTimeout(cubeBuilder.getPostTimeout()).setConnectTimeout(cubeBuilder.getConnectionTimeout()).build();
                DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
                PoolingNHttpClientConnectionManager manager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
                this.closeableHttpAsyncClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)manager).setMaxConnPerRoute(cubeBuilder.getDefaultMaxPerRoute()).setMaxConnTotal(cubeBuilder.getMaxTotalConnections()).setDefaultIOReactorConfig(ioReactorConfig).build();
                this.closeableHttpAsyncClient.start();
            } else {
                PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
                connectionManager.setMaxTotal(cubeBuilder.getMaxTotalConnections());
                connectionManager.setDefaultMaxPerRoute(cubeBuilder.getDefaultMaxPerRoute());
                this.httpclient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doPostBytes(byte[] bytes, String className) {
        try {
            URI uri = new URI(this.getConfig().getCollector());
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes));
            httpPost.setHeader("Content-Type", "application/x-java-serialized-object");
            httpPost.setHeader("X-Sirona-ClassName", className);
            httpPost.setConfig(this.requestConfig);
            if (this.getConfig().isUseAsync()) {
                this.closeableHttpAsyncClient.execute((HttpUriRequest)httpPost, (FutureCallback)new FutureCallback<HttpResponse>(){

                    public void completed(HttpResponse httpResponse) {
                        int status = httpResponse.getStatusLine().getStatusCode();
                        if (status != 200) {
                            LOGGER.warning("Pushed data but response code is: " + status + ", reason:" + httpResponse.getStatusLine().getReasonPhrase());
                        }
                    }

                    public void failed(Exception e) {
                        LOGGER.warning("Failed to push data: " + e.getMessage());
                        e.printStackTrace();
                    }

                    public void cancelled() {
                        LOGGER.warning("Push data cancelled ");
                    }
                });
            } else {
                this.httpclient.execute((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandler<HttpResponse>(){

                    public HttpResponse handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                        int status = httpResponse.getStatusLine().getStatusCode();
                        if (status != 200) {
                            LOGGER.warning("Pushed data but response code is: " + status + ", reason:" + httpResponse.getStatusLine().getReasonPhrase());
                        }
                        return httpResponse;
                    }
                });
            }
        }
        catch (URISyntaxException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Can't post data to collector:" + e.getMessage(), e);
            } else {
                LOGGER.log(Level.WARNING, "Can't post data to collector: " + e.getMessage());
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Can't post data to collector:" + e.getMessage(), e);
            }
            LOGGER.log(Level.WARNING, "Can't post data to collector: " + e.getMessage());
        }
    }
}

