/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.AutoSet;
import org.apache.sirona.configuration.ioc.Created;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.cube.Cube;
import org.apache.sirona.cube.CubeBuilder;
import org.apache.sirona.store.tracking.BatchPathTrackingDataStore;
import org.apache.sirona.store.tracking.CollectorPathTrackingDataStore;
import org.apache.sirona.store.tracking.InMemoryPathTrackingDataStore;
import org.apache.sirona.tracking.PathTrackingEntry;
import org.apache.sirona.util.SerializeUtils;

@AutoSet
public class DisruptorPathTrackingDataStore
extends BatchPathTrackingDataStore
implements CollectorPathTrackingDataStore {
    private static final Cube CUBE = ((CubeBuilder)IoCs.findOrCreateInstance(CubeBuilder.class)).build();
    private static boolean USE_SINGLE_STORE = Boolean.parseBoolean(Configuration.getProperty((String)"org.apache.sirona.pathtracking.singlestore", (String)"false"));
    private RingBuffer<PathTrackingEntry> ringBuffer;
    private Disruptor<PathTrackingEntry> disruptor;
    private int ringBufferSize = 4096;
    private int numberOfConsumers = 4;

    @Created
    public void initialize() {
        ExecutorService exec = Executors.newCachedThreadPool();
        this.disruptor = new Disruptor((EventFactory)new EventFactory<PathTrackingEntry>(){

            public PathTrackingEntry newInstance() {
                return new PathTrackingEntry();
            }
        }, this.ringBufferSize, (Executor)exec, ProducerType.SINGLE, (WaitStrategy)new BusySpinWaitStrategy());
        for (int i = 0; i < this.numberOfConsumers; ++i) {
            this.disruptor.handleEventsWith(new EventHandler[]{new PathTrackingEntryEventHandler(i, this.numberOfConsumers)});
        }
        this.ringBuffer = this.disruptor.start();
    }

    public void store(final PathTrackingEntry pathTrackingEntry) {
        this.ringBuffer.publishEvent((EventTranslator)new EventTranslator<PathTrackingEntry>(){

            public void translateTo(PathTrackingEntry event, long sequence) {
                event.setClassName(pathTrackingEntry.getClassName());
                event.setExecutionTime(pathTrackingEntry.getExecutionTime());
                event.setLevel(pathTrackingEntry.getLevel());
                event.setMethodName(pathTrackingEntry.getMethodName());
                event.setNodeId(pathTrackingEntry.getNodeId());
                event.setStartTime(pathTrackingEntry.getStartTime());
                event.setTrackingId(pathTrackingEntry.getTrackingId());
            }
        });
    }

    protected void pushEntriesByBatch(Map<String, List<InMemoryPathTrackingDataStore.Pointer>> pathTrackingEntries) {
        if (!USE_SINGLE_STORE) {
            for (Map.Entry<String, List<InMemoryPathTrackingDataStore.Pointer>> entry : pathTrackingEntries.entrySet()) {
                for (InMemoryPathTrackingDataStore.Pointer pointer : entry.getValue()) {
                    if (pointer.isFree()) continue;
                    CUBE.doPostBytes(this.readBytes(pointer), PathTrackingEntry.class.getName());
                    pointer.freeMemory();
                }
            }
        }
    }

    public RingBuffer<PathTrackingEntry> getRingBuffer() {
        return this.ringBuffer;
    }

    public void setRingBuffer(RingBuffer<PathTrackingEntry> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }

    public int getNumberOfConsumers() {
        return this.numberOfConsumers;
    }

    public void setNumberOfConsumers(int numberOfConsumers) {
        this.numberOfConsumers = numberOfConsumers;
    }

    public int getRingBufferSize() {
        return this.ringBufferSize;
    }

    public void setRingBufferSize(int ringBufferSize) {
        this.ringBufferSize = ringBufferSize;
    }

    @Destroying
    public void destroy() {
        this.disruptor.shutdown();
    }

    private static class PathTrackingEntryEventHandler
    implements EventHandler<PathTrackingEntry> {
        private final long ordinal;
        private final long numberOfConsumers;

        public PathTrackingEntryEventHandler(long ordinal, long numberOfConsumers) {
            this.ordinal = ordinal;
            this.numberOfConsumers = numberOfConsumers;
        }

        public void onEvent(PathTrackingEntry entry, long sequence, boolean endOfBatch) throws Exception {
            if (sequence % this.numberOfConsumers == this.ordinal) {
                CUBE.doPostBytes(SerializeUtils.serialize((Object)entry), PathTrackingEntry.class.getName());
            }
        }
    }
}

