/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.Role;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.cube.Cube;
import org.apache.sirona.cube.CubeBuilder;
import org.apache.sirona.store.gauge.BatchGaugeDataStoreAdapter;

public class CubeGaugeDataStore
extends BatchGaugeDataStoreAdapter {
    private static final Logger LOGGER = Logger.getLogger(CubeGaugeDataStore.class.getName());
    private final Cube cube = ((CubeBuilder)IoCs.findOrCreateInstance(CubeBuilder.class)).build();

    protected void pushGauges(Map<Role, BatchGaugeDataStoreAdapter.Measure> gauges) {
        StringBuilder events = this.cube.newEventStream();
        for (Map.Entry<Role, BatchGaugeDataStoreAdapter.Measure> entry : gauges.entrySet()) {
            try {
                BatchGaugeDataStoreAdapter.Measure value = entry.getValue();
                this.cube.gaugeSnapshot(events, value.getTime(), entry.getKey(), value.getValue());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.cube.post(events);
    }
}

