/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.DatatypeConverter;
import org.apache.sirona.SironaException;
import org.apache.sirona.configuration.ioc.AutoSet;
import org.apache.sirona.configuration.ioc.Created;
import org.apache.sirona.cube.Cube;
import org.apache.sirona.util.Localhosts;

@AutoSet
public class CubeBuilder {
    private String proxyHost;
    private int proxyPort;
    private String collector;
    private String marker;
    private SSLSocketFactory socketFactory;
    private String sslTrustStore;
    private String sslTrustStoreType;
    private String sslTrustStorePassword;
    private String sslTrustStoreProvider;
    private String sslKeyStore;
    private String sslKeyStoreType;
    private String sslKeyStorePassword;
    private String sslKeyStoreProvider;
    private String basicHeader;
    private boolean useCompression = false;
    private int postTimeout = 5000;
    private int maxTotalConnections = 10;
    private int defaultMaxPerRoute = 10;
    private int connectionTimeout = 5000;
    private int connectionRequestTimeout = 5000;
    private boolean useAsync;
    private int asyncIoThreadCount = Runtime.getRuntime().availableProcessors() - 1;
    private Cube cubeInstance;

    @Created
    public void createInstance() {
        this.cubeInstance = this.build();
    }

    public synchronized Cube build() {
        if (this.cubeInstance != null) {
            return this.cubeInstance;
        }
        if (this.marker == null) {
            this.marker = Localhosts.get();
        }
        if (this.sslKeyStore != null || this.sslTrustStore != null) {
            KeyManager[] keyManagers = this.createKeyManager();
            TrustManager[] trustManagers = this.createTrustManager();
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                this.socketFactory = sslContext.getSocketFactory();
            }
            catch (Exception e) {
                throw new SironaException((Throwable)e);
            }
        } else {
            this.socketFactory = null;
        }
        if (this.basicHeader != null) {
            this.basicHeader = "Basic " + DatatypeConverter.printBase64Binary((byte[])this.basicHeader.getBytes());
        }
        return new Cube(this);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getCollector() {
        return this.collector;
    }

    public String getMarker() {
        return this.marker;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getBasicHeader() {
        return this.basicHeader;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public int getPostTimeout() {
        return this.postTimeout;
    }

    public void setPostTimeout(int postTimeout) {
        this.postTimeout = postTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TrustManager[] createTrustManager() {
        if (this.sslTrustStore == null) {
            return null;
        }
        try {
            KeyStore ks = KeyStore.getInstance(null == this.sslTrustStoreType ? KeyStore.getDefaultType() : this.sslTrustStoreType);
            char[] pwd = this.sslTrustStorePassword != null ? this.sslTrustStorePassword.toCharArray() : "changeit".toCharArray();
            FileInputStream fis = new FileInputStream(this.sslTrustStore);
            try {
                ks.load(fis, pwd);
            }
            finally {
                fis.close();
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(null == this.sslTrustStoreProvider ? TrustManagerFactory.getDefaultAlgorithm() : this.sslTrustStoreProvider);
            tmf.init(ks);
            return tmf.getTrustManagers();
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KeyManager[] createKeyManager() {
        if (this.sslKeyStore == null) {
            return null;
        }
        try {
            KeyStore ks = KeyStore.getInstance(null == this.sslKeyStoreType ? KeyStore.getDefaultType() : this.sslKeyStoreType);
            char[] pwd = this.sslKeyStorePassword != null ? this.sslKeyStorePassword.toCharArray() : "changeit".toCharArray();
            FileInputStream fis = new FileInputStream(this.sslKeyStore);
            try {
                ks.load(fis, pwd);
            }
            finally {
                fis.close();
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(null == this.sslKeyStoreProvider ? KeyManagerFactory.getDefaultAlgorithm() : this.sslKeyStoreProvider);
            kmf.init(ks, pwd);
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new SironaException((Throwable)e);
        }
    }

    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public String getSslTrustStoreProvider() {
        return this.sslTrustStoreProvider;
    }

    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public String getSslKeyStoreProvider() {
        return this.sslKeyStoreProvider;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setCollector(String collector) {
        this.collector = collector;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public void setSocketFactory(SSLSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSslTrustStore(String sslTrustStore) {
        this.sslTrustStore = sslTrustStore;
    }

    public void setSslTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
    }

    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    public void setSslTrustStoreProvider(String sslTrustStoreProvider) {
        this.sslTrustStoreProvider = sslTrustStoreProvider;
    }

    public void setSslKeyStore(String sslKeyStore) {
        this.sslKeyStore = sslKeyStore;
    }

    public void setSslKeyStoreType(String sslKeyStoreType) {
        this.sslKeyStoreType = sslKeyStoreType;
    }

    public void setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    public void setSslKeyStoreProvider(String sslKeyStoreProvider) {
        this.sslKeyStoreProvider = sslKeyStoreProvider;
    }

    public void setBasicHeader(String basicHeader) {
        this.basicHeader = basicHeader;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public boolean isUseAsync() {
        return this.useAsync;
    }

    public void setUseAsync(boolean useAsync) {
        this.useAsync = useAsync;
    }

    public int getAsyncIoThreadCount() {
        return this.asyncIoThreadCount;
    }

    public void setAsyncIoThreadCount(int asyncIoThreadCount) {
        this.asyncIoThreadCount = asyncIoThreadCount;
    }

    public String toString() {
        return "CubeBuilder{" + this.collector + '}';
    }
}

