/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.cube.CubeBuilder;
import org.apache.sirona.cube.MapBuilder;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.status.ValidationResult;
import org.apache.sirona.tracking.PathTrackingEntry;

public class Cube {
    private static final Logger LOGGER = Logger.getLogger(Cube.class.getName());
    private static final String COUNTER_TYPE = "counter";
    private static final String GAUGE_TYPE = "gauge";
    private static final String VALIDATION_TYPE = "validation";
    private static final String STATUS_TYPE = "status";
    private static final String PATHTRACKING_TYPE = "pathtracking";
    private static final String NAME = "name";
    private static final String ROLE = "role";
    private static final String UNIT = "unit";
    private static final String CONCURRENCY = "concurrency";
    private static final String MEAN = "mean";
    private static final String VARIANCE = "variance";
    private static final String HITS = "hits";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String SUM = "sum";
    private static final String M_2 = "m2";
    private static final String TRACKING_D = "trackingId";
    private static final String NODE_ID = "nodeId";
    private static final String CLASSNAME = "className";
    private static final String METHOD_NAME = "methodName";
    private static final String START_TIME = "startTime";
    private static final String EXEC_TIME = "executionTime";
    private static final String LEVEL = "level";
    private static final String JSON_BASE = "{\"type\": \"%s\",\"time\": \"%s\",\"data\": %s}";
    protected static final String POST = "POST";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String CONTENT_LENGTH = "Content-Length";
    protected static final String GZIP_CONTENT_ENCODING = "gzip";
    protected static final String CONTENT_ENCODING = "Content-Encoding";
    protected static final String APPLICATION_JAVA_OBJECT = "application/x-java-serialized-object";
    protected static final String X_SIRONA_CLASSNAME = "X-Sirona-ClassName";
    private static final String JS_ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String UTC = "UTC";
    private final CubeBuilder config;
    private final Proxy proxy;
    private final BlockingQueue<DateFormat> isoDateFormatters;

    public Cube(CubeBuilder cubeBuilder) {
        this.config = cubeBuilder;
        this.proxy = this.config.getProxyHost() != null ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.config.getProxyHost(), this.config.getProxyPort())) : Proxy.NO_PROXY;
        int maxConcurrency = 2 * Runtime.getRuntime().availableProcessors();
        this.isoDateFormatters = new ArrayBlockingQueue<DateFormat>(maxConcurrency);
        for (int i = 0; i < maxConcurrency; ++i) {
            this.isoDateFormatters.add(Cube.newIsoDateFormatter());
        }
    }

    public StringBuilder newEventStream() {
        return new StringBuilder();
    }

    public String globalPayload(StringBuilder payload) {
        if (payload.length() > 0) {
            return Cube.finalPayload(payload.substring(0, payload.length() - 1));
        }
        return Cube.finalPayload(payload.toString());
    }

    public void post(StringBuilder payload) {
        if (payload.length() > 0) {
            this.doPost(this.globalPayload(payload));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPostBytes(byte[] bytes, String className) {
        try {
            String auth;
            URL url = new URL(this.config.getCollector());
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection(this.proxy));
            SSLSocketFactory socketFactory = this.config.getSocketFactory();
            if (socketFactory != null && "https".equals(url.getProtocol())) {
                ((HttpsURLConnection)HttpsURLConnection.class.cast(connection)).setSSLSocketFactory(socketFactory);
            }
            if ((auth = this.config.getBasicHeader()) != null) {
                connection.setRequestProperty("Authorization", auth);
            }
            connection.setRequestMethod(POST);
            connection.setRequestProperty(CONTENT_TYPE, APPLICATION_JAVA_OBJECT);
            connection.setRequestProperty(X_SIRONA_CLASSNAME, className);
            connection.setRequestProperty(CONTENT_LENGTH, Long.toString(bytes.length));
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setReadTimeout(this.config.getPostTimeout());
            OutputStream output = connection.getOutputStream();
            try {
                output.write(bytes);
                output.flush();
                int status = connection.getResponseCode();
                if (status / 100 != 2) {
                    LOGGER.warning("Pushed data but response code is: " + status);
                }
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Can't post data to collector:" + e.getMessage(), e);
            }
            LOGGER.log(Level.WARNING, "Can't post data to collector: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(String payload) {
        try {
            boolean useCompression;
            String auth;
            URL url = new URL(this.config.getCollector());
            HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection(this.proxy));
            SSLSocketFactory socketFactory = this.config.getSocketFactory();
            if (socketFactory != null && "https".equals(url.getProtocol())) {
                ((HttpsURLConnection)HttpsURLConnection.class.cast(connection)).setSSLSocketFactory(socketFactory);
            }
            if ((auth = this.config.getBasicHeader()) != null) {
                connection.setRequestProperty("Authorization", auth);
            }
            byte[] bytes = (useCompression = this.config.isUseCompression()) ? Cube.gzipCompression(payload.getBytes()) : payload.getBytes();
            connection.setRequestMethod(POST);
            connection.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
            if (useCompression) {
                connection.setRequestProperty(CONTENT_ENCODING, GZIP_CONTENT_ENCODING);
            }
            connection.setRequestProperty(CONTENT_LENGTH, Long.toString(bytes.length));
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setReadTimeout(this.config.getPostTimeout());
            OutputStream output = null;
            output = connection.getOutputStream();
            try {
                output.write(bytes);
                output.flush();
                int status = connection.getResponseCode();
                if (status / 100 != 2) {
                    LOGGER.warning("Pushed data but response code is: " + status);
                }
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Can't post data to collector", e);
        }
    }

    private static byte[] gzipCompression(byte[] unCompress) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(buffer);
        out.write(unCompress);
        out.finish();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
        byte[] res = Cube.toByteArray(bais);
        return res;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    public static String finalPayload(String events) {
        return '[' + events + ']';
    }

    public StringBuilder buildEvent(StringBuilder builder, String type, long time, Map<String, Object> data) {
        data.put("marker", this.config.getMarker());
        return builder.append(String.format(JSON_BASE, type, this.isoDate(time), Cube.buildData(data))).append(',');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String isoDate(long time) {
        Date date = new Date(time);
        DateFormat formatter = null;
        try {
            formatter = this.isoDateFormatters.take();
            String string = formatter.format(date);
            return string;
        }
        catch (InterruptedException e) {
            String string = Cube.newIsoDateFormatter().format(date);
            return string;
        }
        finally {
            if (formatter != null) {
                this.isoDateFormatters.add(formatter);
            }
        }
    }

    private static String buildData(Map<String, Object> data) {
        StringBuilder builder = new StringBuilder().append("{");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            builder.append('\"').append(entry.getKey()).append('\"').append(':');
            Object value = entry.getValue();
            if (String.class.isInstance(value)) {
                builder.append('\"').append(value).append('\"');
            } else {
                builder.append(value);
            }
            builder.append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append("}").toString();
    }

    private static DateFormat newIsoDateFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(JS_ISO_FORMAT, Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(UTC));
        return simpleDateFormat;
    }

    public StringBuilder counterSnapshot(Collection<Counter> instances) {
        long ts = System.currentTimeMillis();
        StringBuilder events = this.newEventStream();
        for (Counter counter : instances) {
            this.buildEvent(events, COUNTER_TYPE, ts, new MapBuilder().add(NAME, counter.getKey().getName()).add(ROLE, counter.getKey().getRole().getName()).add(UNIT, counter.getKey().getRole().getUnit().getName()).add(CONCURRENCY, counter.currentConcurrency().intValue()).add(MEAN, counter.getMean()).add(VARIANCE, counter.getVariance()).add(HITS, counter.getHits()).add(MAX, counter.getMax()).add(MIN, counter.getMin()).add(SUM, counter.getSum()).add(M_2, counter.getSecondMoment()).map());
        }
        return events;
    }

    public StringBuilder pathTrackingSnapshot(Collection<PathTrackingEntry> pathTrackingEntries) {
        StringBuilder events = this.newEventStream();
        long ts = System.currentTimeMillis();
        for (PathTrackingEntry pathTrackingEntry : pathTrackingEntries) {
            this.buildEvent(events, PATHTRACKING_TYPE, ts, new MapBuilder().add(TRACKING_D, pathTrackingEntry.getTrackingId()).add(NODE_ID, pathTrackingEntry.getNodeId()).add(CLASSNAME, pathTrackingEntry.getClassName()).add(METHOD_NAME, pathTrackingEntry.getMethodName()).add(START_TIME, pathTrackingEntry.getStartTime()).add(EXEC_TIME, pathTrackingEntry.getExecutionTime()).add(LEVEL, pathTrackingEntry.getLevel()).map());
        }
        return events;
    }

    public StringBuilder pathTrackingSnapshot(PathTrackingEntry pathTrackingEntry) {
        StringBuilder event = this.newEventStream();
        long ts = System.currentTimeMillis();
        this.buildEvent(event, PATHTRACKING_TYPE, ts, new MapBuilder().add(TRACKING_D, pathTrackingEntry.getTrackingId()).add(NODE_ID, pathTrackingEntry.getNodeId()).add(CLASSNAME, pathTrackingEntry.getClassName()).add(METHOD_NAME, pathTrackingEntry.getMethodName()).add(START_TIME, pathTrackingEntry.getStartTime()).add(EXEC_TIME, pathTrackingEntry.getExecutionTime()).add(LEVEL, pathTrackingEntry.getLevel()).map());
        return event;
    }

    public StringBuilder gaugeSnapshot(StringBuilder base, long time, Role role, double value) {
        return this.buildEvent(base, GAUGE_TYPE, time, new MapBuilder().add("value", value).add(ROLE, role.getName()).add(UNIT, role.getUnit().getName()).map());
    }

    public StringBuilder statusSnapshot(long ts, NodeStatus nodeStatus) {
        StringBuilder events = this.newEventStream();
        for (ValidationResult result : nodeStatus.getResults()) {
            this.buildEvent(events, VALIDATION_TYPE, ts, new MapBuilder().add("message", result.getMessage()).add(STATUS_TYPE, result.getStatus().name()).add(NAME, result.getName()).map());
        }
        if (nodeStatus.getDate() != null) {
            this.buildEvent(events, STATUS_TYPE, ts, new MapBuilder().add("date", nodeStatus.getDate().getTime()).map());
        }
        return events;
    }

    protected CubeBuilder getConfig() {
        return this.config;
    }
}

