/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.cube;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.cube.Cube;
import org.apache.sirona.cube.CubeBuilder;

public class AsyncHttpClientCube
extends Cube {
    private static final Logger LOGGER = Logger.getLogger(AsyncHttpClientCube.class.getName());
    private AsyncHttpClient asyncHttpClient;

    public AsyncHttpClientCube(CubeBuilder cubeBuilder) {
        super(cubeBuilder);
        NettyAsyncHttpProviderConfig conf = new NettyAsyncHttpProviderConfig();
        conf.addProperty("bossExecutorService", (Object)Executors.newSingleThreadExecutor());
        AsyncHttpClientConfig asyncHttpClientConfig = new AsyncHttpClientConfig.Builder().setAsyncHttpClientProviderConfig((AsyncHttpProviderConfig)conf).setAllowPoolingConnection(true).setAllowSslConnectionPool(true).setConnectionTimeoutInMs(cubeBuilder.getConnectionTimeout()).setRequestTimeoutInMs(cubeBuilder.getPostTimeout()).setMaxRequestRetry(1).setMaximumConnectionsPerHost(cubeBuilder.getDefaultMaxPerRoute()).setMaximumConnectionsTotal(cubeBuilder.getMaxTotalConnections()).build();
        this.asyncHttpClient = new AsyncHttpClient(asyncHttpClientConfig);
    }

    @Override
    public void doPostBytes(byte[] bytes, String className) {
        try {
            this.asyncHttpClient.preparePost(this.getConfig().getCollector()).setBody(bytes).addHeader("Content-Type", "application/x-java-serialized-object").addHeader("X-Sirona-ClassName", className).execute((AsyncHandler)new AsyncHandler<String>(){

                public void onThrowable(Throwable throwable) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Can't post data to collector:" + throwable.getMessage(), throwable);
                    } else {
                        LOGGER.log(Level.WARNING, "Can't post data to collector: " + throwable.getMessage());
                    }
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart httpResponseBodyPart) throws Exception {
                    return AsyncHandler.STATE.ABORT;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus httpResponseStatus) throws Exception {
                    int statusCode = httpResponseStatus.getStatusCode();
                    if (statusCode != 200) {
                        LOGGER.warning("Pushed data but response code is: " + statusCode + ", reason:" + httpResponseStatus.getStatusText());
                    }
                    return AsyncHandler.STATE.ABORT;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders httpResponseHeaders) throws Exception {
                    return AsyncHandler.STATE.ABORT;
                }

                public String onCompleted() throws Exception {
                    return null;
                }
            });
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Can't post data to collector:" + e.getMessage(), e);
            }
            LOGGER.log(Level.WARNING, "Can't post data to collector: " + e.getMessage());
        }
    }
}

