/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package com.ning.http.client.providers.netty.timeout;

import org.jboss.netty.util.Timeout;

import java.util.concurrent.atomic.AtomicBoolean;

public class TimeoutsHolder {

    private AtomicBoolean cancelled = new AtomicBoolean();
    public volatile Timeout requestTimeout;
    public volatile Timeout idleConnectionTimeout;

    public void cancel() {
        if (cancelled.compareAndSet(false, true)) {
            requestTimeout.cancel();
            idleConnectionTimeout.cancel();
            requestTimeout = null;
            idleConnectionTimeout = null;
        }
    }
}
