/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.guice.web.SimpleFilterChain;
import org.apache.shiro.util.PatternMatcher;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.util.WebUtils;

class SimpleFilterChainResolver
implements FilterChainResolver {
    private final Map<String, Key<? extends Filter>[]> chains;
    private final Injector injector;
    private final PatternMatcher patternMatcher;

    SimpleFilterChainResolver(Map<String, Key<? extends Filter>[]> chains, Injector injector, PatternMatcher patternMatcher) {
        this.chains = chains;
        this.injector = injector;
        this.patternMatcher = patternMatcher;
    }

    public FilterChain getChain(ServletRequest request, ServletResponse response, FilterChain originalChain) {
        String path = WebUtils.getPathWithinApplication((HttpServletRequest)WebUtils.toHttp((ServletRequest)request));
        for (String pathPattern : this.chains.keySet()) {
            if (!this.patternMatcher.matches(pathPattern, path)) continue;
            final Iterator<Key<? extends Filter>> chain = Arrays.asList(this.chains.get(pathPattern)).iterator();
            return new SimpleFilterChain(originalChain, (Iterator<? extends Filter>)new Iterator<Filter>(){
                final /* synthetic */ SimpleFilterChainResolver this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return chain.hasNext();
                }

                @Override
                public Filter next() {
                    return (Filter)this.this$0.injector.getInstance((Key)chain.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return null;
    }
}

