/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.cipher;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import org.apache.shiro.crypto.cipher.JcaCipherService;

public abstract class AbstractSymmetricCipherService
extends JcaCipherService {
    protected AbstractSymmetricCipherService(String algorithmName) {
        super(algorithmName);
    }

    public Key generateNewKey() {
        return this.generateNewKey(this.getKeySize());
    }

    public Key generateNewKey(int keyBitSize) {
        KeyGenerator kg;
        try {
            kg = KeyGenerator.getInstance(this.getAlgorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Unable to acquire " + this.getAlgorithmName() + " algorithm.  This is required to function.";
            throw new IllegalStateException(msg, e);
        }
        kg.init(keyBitSize);
        return kg.generateKey();
    }
}

