/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.support.hashes.bcrypt;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.shiro.crypto.hash.AbstractCryptHash;
import org.apache.shiro.crypto.support.hashes.bcrypt.OpenBSDBase64;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.SimpleByteSource;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BCryptHash
extends AbstractCryptHash {
    public static final String DEFAULT_ALGORITHM_NAME = "2y";
    public static final int DEFAULT_COST = 10;
    public static final int SALT_LENGTH = 16;
    private static final long serialVersionUID = 6957869292324606101L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCryptHash.class);
    private static final Set<String> ALGORITHMS_BCRYPT = new HashSet<String>(Arrays.asList("2", "2a", "2b", "2y"));
    private final int cost;
    private final int iterations;

    BCryptHash(String version, byte[] hashedData, ByteSource salt, int cost) {
        super(version, hashedData, salt);
        this.cost = cost;
        this.iterations = (int)Math.pow(2.0, cost);
        this.checkValidCost();
    }

    protected final void checkValidAlgorithm() {
        if (!ALGORITHMS_BCRYPT.contains(this.getAlgorithmName())) {
            String message = String.format(Locale.ENGLISH, "Given algorithm name [%s] not valid for bcrypt. Valid algorithms: [%s].", this.getAlgorithmName(), ALGORITHMS_BCRYPT);
            throw new IllegalArgumentException(message);
        }
    }

    protected final void checkValidCost() {
        BCryptHash.checkValidCost(this.cost);
    }

    public static int checkValidCost(int cost) {
        if (cost < 4 || cost > 31) {
            String message = String.format(Locale.ENGLISH, "Expected bcrypt cost >= 4 and <=30, but was [%d].", cost);
            throw new IllegalArgumentException(message);
        }
        return cost;
    }

    public int getCost() {
        return this.cost;
    }

    public static Set<String> getAlgorithmsBcrypt() {
        return Collections.unmodifiableSet(ALGORITHMS_BCRYPT);
    }

    public static BCryptHash fromString(String input) {
        if (!input.startsWith("$")) {
            throw new IllegalArgumentException("Unsupported input: " + input);
        }
        Object[] parts = AbstractCryptHash.DELIMITER.split(input.substring(1));
        if (parts.length != 3) {
            throw new IllegalArgumentException("Expected string containing three '$' but got: '" + Arrays.toString(parts) + "'.");
        }
        String algorithmName = parts[0].trim();
        int cost = Integer.parseInt(((String)parts[1]).trim(), 10);
        Object dataSection = parts[2];
        OpenBSDBase64.Default bcryptBase64 = new OpenBSDBase64.Default();
        String saltBase64 = ((String)dataSection).substring(0, 22);
        String bytesBase64 = ((String)dataSection).substring(22);
        byte[] salt = bcryptBase64.decode(saltBase64.getBytes(StandardCharsets.ISO_8859_1));
        byte[] hashedData = bcryptBase64.decode(bytesBase64.getBytes(StandardCharsets.ISO_8859_1));
        return new BCryptHash(algorithmName, hashedData, (ByteSource)new SimpleByteSource(salt), cost);
    }

    public static BCryptHash generate(ByteSource source) {
        return BCryptHash.generate(source, BCryptHash.createSalt(), 10);
    }

    public static BCryptHash generate(ByteSource source, ByteSource initialSalt, int cost) {
        return BCryptHash.generate(DEFAULT_ALGORITHM_NAME, source, initialSalt, cost);
    }

    public static BCryptHash generate(String algorithmName, ByteSource source, ByteSource salt, int cost) {
        BCryptHash.checkValidCost(cost);
        String cryptString = OpenBSDBCrypt.generate((String)algorithmName, (byte[])source.getBytes(), (byte[])salt.getBytes(), (int)cost);
        return BCryptHash.fromString(cryptString);
    }

    protected static ByteSource createSalt() {
        return BCryptHash.createSalt(new SecureRandom());
    }

    protected static ByteSource createSalt(SecureRandom random) {
        return new SimpleByteSource(random.generateSeed(16));
    }

    public int getSaltLength() {
        return 16;
    }

    public String formatToCryptString() {
        OpenBSDBase64.Default bsdBase64 = new OpenBSDBase64.Default();
        String saltBase64 = new String(bsdBase64.encode(this.getSalt().getBytes()), StandardCharsets.ISO_8859_1);
        String dataBase64 = new String(bsdBase64.encode(this.getBytes()), StandardCharsets.ISO_8859_1);
        return new StringJoiner("$", "$", "").add(this.getAlgorithmName()).add("" + this.cost).add(saltBase64 + dataBase64).toString();
    }

    public int getIterations() {
        return this.iterations;
    }

    public boolean matchesPassword(ByteSource plaintextBytes) {
        try {
            String cryptString = OpenBSDBCrypt.generate((String)this.getAlgorithmName(), (byte[])plaintextBytes.getBytes(), (byte[])this.getSalt().getBytes(), (int)this.getCost());
            BCryptHash other = BCryptHash.fromString(cryptString);
            return this.equals((Object)other);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.warn("Cannot recreate a hash using the same parameters.", (Throwable)illegalArgumentException);
            return false;
        }
    }

    public String toString() {
        return new StringJoiner(", ", BCryptHash.class.getSimpleName() + "[", "]").add("super=" + super.toString()).add("cost=" + this.cost).toString();
    }
}

