/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.core;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;

public abstract class AbstractPathDataSyncService
implements SyncDataService {
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;
    private final List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers;
    private final List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers;

    public AbstractPathDataSyncService(PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers) {
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.proxySelectorDataSubscribers = proxySelectorDataSubscribers;
        this.discoveryUpstreamDataSubscribers = discoveryUpstreamDataSubscribers;
    }

    public void event(String namespaceId, String updatePath, String updateData, String registerPath, EventType eventType) {
        String realRegisterPath;
        String realUpdatePath = StringUtils.substringAfter((String)updatePath, (String)namespaceId);
        switch (realRegisterPath = StringUtils.substringAfter((String)registerPath, (String)namespaceId)) {
            case "/shenyu/plugin": {
                this.pluginHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
            case "/shenyu/selector": {
                this.selectorHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
            case "/shenyu/metaData": {
                this.metaDataHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
            case "/shenyu/auth": {
                this.appAuthHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
            case "/shenyu/rule": {
                this.ruleHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
            case "/shenyu/discoveryUpstream": {
                this.discoveryUpstreamHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
            case "/shenyu/proxySelectorData": {
                this.proxyHandlerEvent(realUpdatePath, updateData, eventType);
                break;
            }
        }
    }

    private void proxyHandlerEvent(String updatePath, String updateData, EventType eventType) {
        String[] pathInfoArray = updatePath.split("/");
        if (pathInfoArray.length != 5) {
            return;
        }
        String pluginName = pathInfoArray[pathInfoArray.length - 2];
        String proxySelectorName = pathInfoArray[pathInfoArray.length - 1];
        if (EventType.DELETE.equals((Object)eventType)) {
            ProxySelectorData proxySelectorData = new ProxySelectorData();
            proxySelectorData.setPluginName(pluginName);
            proxySelectorData.setName(proxySelectorName);
            this.unCacheProxySelectorData(proxySelectorData);
            return;
        }
        ProxySelectorData proxySelectorData = (ProxySelectorData)GsonUtils.getInstance().fromJson(updateData, ProxySelectorData.class);
        proxySelectorData.setName(proxySelectorName);
        proxySelectorData.setPluginName(pluginName);
        Optional.ofNullable(updateData).ifPresent(e -> this.cacheProxySelectorData(proxySelectorData));
    }

    private void discoveryUpstreamHandlerEvent(String updatePath, String updateData, EventType eventType) {
        String[] pathInfoArray2 = updatePath.split("/");
        if (pathInfoArray2.length != 5) {
            return;
        }
        if (!EventType.DELETE.equals((Object)eventType)) {
            Optional.ofNullable(updateData).ifPresent(e -> this.cacheDiscoveryUpstreamData((DiscoverySyncData)GsonUtils.getInstance().fromJson(updateData, DiscoverySyncData.class)));
        }
    }

    private void ruleHandlerEvent(String updatePath, String updateData, EventType eventType) {
        if (EventType.DELETE.equals((Object)eventType)) {
            this.unCacheRuleData(updatePath);
            return;
        }
        Optional.ofNullable(updateData).ifPresent(e -> this.cacheRuleData((RuleData)GsonUtils.getInstance().fromJson(updateData, RuleData.class)));
    }

    private void appAuthHandlerEvent(String updatePath, String updateData, EventType eventType) {
        if (EventType.DELETE.equals((Object)eventType)) {
            this.unCacheAuthData(updatePath);
            return;
        }
        Optional.ofNullable(updateData).ifPresent(e -> this.cacheAuthData((AppAuthData)GsonUtils.getInstance().fromJson(updateData, AppAuthData.class)));
    }

    private void metaDataHandlerEvent(String updatePath, String updateData, EventType eventType) {
        if (EventType.DELETE.equals((Object)eventType)) {
            String realPath = updatePath.substring("/shenyu/metaData".length() + 1);
            MetaData metaData = new MetaData();
            metaData.setPath(URLDecoder.decode(realPath, StandardCharsets.UTF_8));
            this.unCacheMetaData(metaData);
            return;
        }
        Optional.ofNullable(updateData).ifPresent(e -> this.cacheMetaData((MetaData)GsonUtils.getInstance().fromJson(updateData, MetaData.class)));
    }

    private void selectorHandlerEvent(String updatePath, String updateData, EventType eventType) {
        if (EventType.DELETE.equals((Object)eventType)) {
            this.unCacheSelectorData(updatePath);
            return;
        }
        Optional.ofNullable(updateData).ifPresent(e -> this.cacheSelectorData((SelectorData)GsonUtils.getInstance().fromJson(updateData, SelectorData.class)));
    }

    private void pluginHandlerEvent(String updatePath, String updateData, EventType eventType) {
        if (EventType.DELETE.equals((Object)eventType)) {
            String pluginName = updatePath.substring(updatePath.lastIndexOf("/") + 1);
            this.unCachePluginName(pluginName);
            return;
        }
        Optional.ofNullable(updateData).ifPresent(e -> this.cachePluginData((PluginData)GsonUtils.getInstance().fromJson(updateData, PluginData.class)));
    }

    protected void cachePluginData(PluginData pluginData) {
        Optional.ofNullable(pluginData).flatMap(data -> Optional.ofNullable(this.pluginDataSubscriber)).ifPresent(e -> e.onSubscribe(pluginData));
    }

    protected void cacheSelectorData(SelectorData selectorData) {
        Optional.ofNullable(selectorData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe((SelectorData)data)));
    }

    protected void unCacheSelectorData(String dataPath) {
        SelectorData selectorData = new SelectorData();
        String selectorId = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/selector".length());
        int pluginNameIndex = str.length() - selectorId.length() - 1;
        if (pluginNameIndex <= 0) {
            return;
        }
        String pluginName = str.substring(1, pluginNameIndex);
        selectorData.setPluginName(pluginName);
        selectorData.setId(selectorId);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData));
    }

    protected void unCachePluginName(String pluginName) {
        PluginData pluginData = new PluginData();
        pluginData.setName(pluginName);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(pluginData));
    }

    protected void cacheRuleData(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe((RuleData)data)));
    }

    protected void unCacheRuleData(String dataPath) {
        String ruleDataId = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/shenyu/rule".length());
        int pluginNameIndex = str.length() - ruleDataId.length() - 1;
        if (pluginNameIndex <= 0) {
            return;
        }
        String pluginName = str.substring(1, pluginNameIndex);
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"-").split((CharSequence)ruleDataId));
        RuleData ruleData = new RuleData();
        ruleData.setPluginName(pluginName);
        ruleData.setSelectorId((String)list.get(0));
        ruleData.setId((String)list.get(1));
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData));
    }

    protected void cacheAuthData(AppAuthData appAuthData) {
        Optional.ofNullable(appAuthData).ifPresent(data -> this.authDataSubscribers.forEach(e -> e.onSubscribe((AppAuthData)data)));
    }

    protected void unCacheAuthData(String dataPath) {
        String key = dataPath.substring("/shenyu/auth".length() + 1);
        AppAuthData appAuthData = new AppAuthData();
        appAuthData.setAppKey(key);
        this.authDataSubscribers.forEach(e -> e.unSubscribe(appAuthData));
    }

    protected void cacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.onSubscribe(metaData)));
    }

    protected void cacheProxySelectorData(ProxySelectorData proxySelectorData) {
        Optional.ofNullable(proxySelectorData).ifPresent(data -> this.proxySelectorDataSubscribers.forEach(e -> e.onSubscribe(proxySelectorData)));
    }

    protected void cacheDiscoveryUpstreamData(DiscoverySyncData upstreamDataList) {
        Optional.ofNullable(this.discoveryUpstreamDataSubscribers).ifPresent(data -> this.discoveryUpstreamDataSubscribers.forEach(e -> e.onSubscribe(upstreamDataList)));
    }

    protected void unCacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.unSubscribe(metaData)));
    }

    protected void unCacheProxySelectorData(ProxySelectorData proxySelectorData) {
        Optional.ofNullable(proxySelectorData).ifPresent(data -> this.proxySelectorDataSubscribers.forEach(e -> e.unSubscribe(proxySelectorData)));
    }

    public static enum EventType {
        PUT,
        DELETE;

    }
}

