/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.sync.data.etcd;

import io.etcd.jetcd.Client;
import java.util.Collections;
import java.util.List;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.springboot.sync.data.etcd.EtcdConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.etcd.EtcdClient;
import org.apache.shenyu.sync.data.etcd.EtcdSyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={EtcdSyncDataConfiguration.class})
@ConditionalOnProperty(prefix="shenyu.sync.etcd", name={"url"})
@EnableConfigurationProperties(value={EtcdConfig.class})
public class EtcdSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdSyncDataConfiguration.class);

    @Bean
    public SyncDataService syncDataService(ObjectProvider<ShenyuConfig> shenyuConfig, ObjectProvider<EtcdClient> etcdClients, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers, ObjectProvider<List<ProxySelectorDataSubscriber>> proxySelectorDataSubscribers, ObjectProvider<List<DiscoveryUpstreamDataSubscriber>> discoveryUpstreamDataSubscribers) {
        LOGGER.info("you use etcd sync shenyu data.......");
        return new EtcdSyncDataService((ShenyuConfig)shenyuConfig.getIfAvailable(), (EtcdClient)etcdClients.getIfAvailable(), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList), (List)proxySelectorDataSubscribers.getIfAvailable(Collections::emptyList), (List)discoveryUpstreamDataSubscribers.getIfAvailable(Collections::emptyList));
    }

    @Bean
    public EtcdClient etcdClient(EtcdConfig etcdConfig) {
        Client client = Client.builder().endpoints(etcdConfig.getUrl().split(",")).build();
        return new EtcdClient(client);
    }
}

