/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.RedisSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.RedisSessionRepository;
import org.springframework.session.data.redis.config.ConfigureNotifyKeyspaceEventsAction;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.http.RedisIndexedHttpSessionConfiguration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RedisTemplate.class, RedisIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@EnableConfigurationProperties(value={RedisSessionProperties.class})
class RedisSessionConfiguration {
    RedisSessionConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.session.redis", name={"repository-type"}, havingValue="indexed")
    @Import(value={RedisIndexedHttpSessionConfiguration.class})
    static class IndexedRedisSessionConfiguration {
        IndexedRedisSessionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ConfigureRedisAction configureRedisAction(RedisSessionProperties redisSessionProperties) {
            return switch (redisSessionProperties.getConfigureAction()) {
                default -> throw new IncompatibleClassChangeError();
                case RedisSessionProperties.ConfigureAction.NOTIFY_KEYSPACE_EVENTS -> new ConfigureNotifyKeyspaceEventsAction();
                case RedisSessionProperties.ConfigureAction.NONE -> ConfigureRedisAction.NO_OP;
            };
        }

        @Bean
        @Order(value=-2147483648)
        SessionRepositoryCustomizer<RedisIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
            return sessionRepository -> {
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from(sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
                map.from(redisSessionProperties::getFlushMode).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setFlushMode(arg_0));
                map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
                map.from(redisSessionProperties::getCleanupCron).to(arg_0 -> ((RedisIndexedSessionRepository)sessionRepository).setCleanupCron(arg_0));
            };
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="spring.session.redis", name={"repository-type"}, havingValue="default", matchIfMissing=true)
    @Import(value={RedisHttpSessionConfiguration.class})
    static class DefaultRedisSessionConfiguration {
        DefaultRedisSessionConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        SessionRepositoryCustomizer<RedisSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties, ServerProperties serverProperties) {
            String cleanupCron = redisSessionProperties.getCleanupCron();
            if (cleanupCron != null) {
                throw new InvalidConfigurationPropertyValueException("spring.session.redis.cleanup-cron", cleanupCron, "Cron-based cleanup is only supported when spring.session.redis.repository-type is set to indexed.");
            }
            return sessionRepository -> {
                PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
                map.from(sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
                map.from(redisSessionProperties::getNamespace).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setRedisKeyNamespace(arg_0));
                map.from(redisSessionProperties::getFlushMode).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setFlushMode(arg_0));
                map.from(redisSessionProperties::getSaveMode).to(arg_0 -> ((RedisSessionRepository)sessionRepository).setSaveMode(arg_0));
            };
        }
    }
}

