/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.constant.ApolloPathConstants;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.ProxySelectorDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.core.AbstractNodeDataSyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloDataService
extends AbstractNodeDataSyncService
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(ApolloDataService.class);
    private final Config configService;
    private ConfigChangeListener watchConfigChangeListener;

    public ApolloDataService(Config configService, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, List<ProxySelectorDataSubscriber> proxySelectorDataSubscribers, List<DiscoveryUpstreamDataSubscriber> discoveryUpstreamDataSubscribers, ShenyuConfig shenyuConfig) {
        super(new AbstractNodeDataSyncService.ChangeData("plugin", "selector", "rule", "auth", "meta", "proxy.selector", "discovery"), pluginDataSubscriber, metaDataSubscribers, authDataSubscribers, proxySelectorDataSubscribers, discoveryUpstreamDataSubscribers, shenyuConfig);
        this.configService = configService;
        this.startWatch();
        this.apolloWatchPrefixes();
    }

    private void apolloWatchPrefixes() {
        ConfigChangeListener listener;
        this.watchConfigChangeListener = listener = changeEvent -> changeEvent.changedKeys().forEach(changeKey -> {
            try {
                ConfigChange configChange = changeEvent.getChange((String)changeKey);
                if (Objects.isNull(configChange)) {
                    LOG.error("apollo watchPrefixes error configChange is null {}", changeKey);
                    return;
                }
                String newValue = configChange.getNewValue();
                int lastListStrIndex = changeKey.length() - "list".length();
                if (changeKey.lastIndexOf("list") == lastListStrIndex) {
                    return;
                }
                if (changeKey.indexOf("plugin") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCachePluginData((String)changeKey);
                    } else {
                        this.cachePluginData(newValue);
                    }
                } else if (changeKey.indexOf("selector") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCacheSelectorData((String)changeKey);
                    } else {
                        this.cacheSelectorData(newValue);
                    }
                } else if (changeKey.indexOf("rule") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCacheRuleData((String)changeKey);
                    } else {
                        this.cacheRuleData(newValue);
                    }
                } else if (changeKey.indexOf("auth") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCacheAuthData((String)changeKey);
                    } else {
                        this.cacheAuthData(newValue);
                    }
                } else if (changeKey.indexOf("meta") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCacheMetaData((String)changeKey);
                    } else {
                        this.cacheMetaData(newValue);
                    }
                } else if (changeKey.indexOf("proxy.selector") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCacheProxySelectorData((String)changeKey);
                    } else {
                        this.cacheProxySelectorData(newValue);
                    }
                } else if (changeKey.indexOf("discovery") == 0) {
                    if (PropertyChangeType.DELETED.equals((Object)configChange.getChangeType())) {
                        this.unCacheDiscoveryUpstreamData((String)changeKey);
                    } else {
                        this.cacheDiscoveryUpstreamData(newValue);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("apollo sync listener change key handler error", e);
            }
        });
        this.configService.addChangeListener(listener, Collections.emptySet(), ApolloPathConstants.pathKeySet());
    }

    @Override
    protected void doRemoveListener(String key) {
    }

    @Override
    protected String getServiceConfig(String key, Consumer<String> updateHandler, Consumer<String> deleteHandler) {
        return this.configService.getProperty(key, null);
    }

    @Override
    public void close() {
        if (!ObjectUtils.isEmpty(this.watchConfigChangeListener)) {
            this.configService.removeChangeListener(this.watchConfigChangeListener);
        }
    }
}

