/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public abstract class AbstractChannelMetricsHandler
extends ChannelDuplexHandler {
    private static final Logger log = Loggers.getLogger(AbstractChannelMetricsHandler.class);
    final SocketAddress remoteAddress;
    final boolean onServer;
    boolean channelOpened;
    SocketAddress proxyAddress;

    protected AbstractChannelMetricsHandler(@Nullable SocketAddress remoteAddress, boolean onServer) {
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        block3: {
            if (this.onServer) {
                try {
                    this.channelOpened = true;
                    this.recorder().recordServerConnectionOpened(ctx.channel().localAddress());
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        ctx.fireChannelActive();
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        block4: {
            if (this.onServer) {
                try {
                    if (this.channelOpened) {
                        this.channelOpened = false;
                        this.recorder().recordServerConnectionClosed(ctx.channel().localAddress());
                    }
                }
                catch (RuntimeException e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) {
        ChannelHandler sslHandler;
        if (!this.onServer) {
            ChannelHandler proxyHandler = ctx.pipeline().get("reactor.left.proxyHandler");
            if (proxyHandler != null) {
                this.proxyAddress = ((ProxyHandler)proxyHandler).proxyAddress();
            }
            ctx.pipeline().addAfter("reactor.left.channelMetricsHandler", "reactor.left.connectMetricsHandler", this.connectMetricsHandler());
        }
        if ((sslHandler = ctx.pipeline().get("reactor.left.sslHandler")) instanceof SslHandler) {
            ctx.pipeline().addBefore("reactor.left.sslHandler", "reactor.left.tlsMetricsHandler", this.tlsMetricsHandler());
        } else if (sslHandler instanceof AbstractSniHandler) {
            ctx.pipeline().addAfter("reactor.left.sslHandler", "reactor.left.tlsMetricsHandler", this.tlsMetricsHandler());
        }
        ctx.fireChannelRegistered();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        block6: {
            try {
                DatagramPacket p;
                ByteBuf buffer;
                if (msg instanceof ByteBuf) {
                    ByteBuf buffer2 = (ByteBuf)msg;
                    if (buffer2.readableBytes() > 0) {
                        this.recordRead(ctx, this.remoteAddress, buffer2.readableBytes());
                    }
                } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
                    this.recordRead(ctx, this.remoteAddress != null ? this.remoteAddress : p.sender(), buffer.readableBytes());
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        block6: {
            try {
                DatagramPacket p;
                ByteBuf buffer;
                if (msg instanceof ByteBuf) {
                    ByteBuf buffer2 = (ByteBuf)msg;
                    if (buffer2.readableBytes() > 0) {
                        this.recordWrite(ctx, this.remoteAddress, buffer2.readableBytes());
                    }
                } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
                    this.recordWrite(ctx, this.remoteAddress != null ? this.remoteAddress : p.recipient(), buffer.readableBytes());
                }
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.write(msg, promise);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        block2: {
            try {
                this.recordException(ctx, this.remoteAddress != null ? this.remoteAddress : ctx.channel().remoteAddress());
            }
            catch (RuntimeException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
            }
        }
        ctx.fireExceptionCaught(cause);
    }

    public abstract ChannelHandler connectMetricsHandler();

    public abstract ChannelHandler tlsMetricsHandler();

    public abstract ChannelMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx, SocketAddress address) {
        if (this.proxyAddress == null) {
            this.recorder().incrementErrorsCount(address);
        } else {
            this.recorder().incrementErrorsCount(address, this.proxyAddress);
        }
    }

    protected void recordRead(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        if (this.proxyAddress == null) {
            this.recorder().recordDataReceived(address, bytes);
        } else {
            this.recorder().recordDataReceived(address, this.proxyAddress, bytes);
        }
    }

    protected void recordWrite(ChannelHandlerContext ctx, SocketAddress address, long bytes) {
        if (this.proxyAddress == null) {
            this.recorder().recordDataSent(address, bytes);
        } else {
            this.recorder().recordDataSent(address, this.proxyAddress, bytes);
        }
    }
}

