/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.undertow.UndertowOptions;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.undertow.ConfigurableUndertowWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.unit.DataSize;
import org.xnio.Option;
import org.xnio.Options;

public class UndertowWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableUndertowWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public UndertowWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(ConfigurableUndertowWebServerFactory factory) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ServerOptions options = new ServerOptions(factory);
        ServerProperties properties = this.serverProperties;
        map.from(properties::getMaxHttpRequestHeaderSize).asInt(DataSize::toBytes).when(this::isPositive).to(options.option(UndertowOptions.MAX_HEADER_SIZE));
        this.mapUndertowProperties(factory, options);
        this.mapAccessLogProperties(factory);
        map.from(this::getOrDeduceUseForwardHeaders).to(factory::setUseForwardHeaders);
    }

    private void mapUndertowProperties(ConfigurableUndertowWebServerFactory factory, ServerOptions serverOptions) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ServerProperties.Undertow properties = this.serverProperties.getUndertow();
        map.from(properties::getBufferSize).whenNonNull().asInt(DataSize::toBytes).to(factory::setBufferSize);
        ServerProperties.Undertow.Threads threadProperties = properties.getThreads();
        map.from(threadProperties::getIo).to(factory::setIoThreads);
        map.from(threadProperties::getWorker).to(factory::setWorkerThreads);
        map.from(properties::getDirectBuffers).to(factory::setUseDirectBuffers);
        map.from(properties::getMaxHttpPostSize).as(DataSize::toBytes).when(this::isPositive).to(serverOptions.option(UndertowOptions.MAX_ENTITY_SIZE));
        map.from(properties::getMaxParameters).to(serverOptions.option(UndertowOptions.MAX_PARAMETERS));
        map.from(properties::getMaxHeaders).to(serverOptions.option(UndertowOptions.MAX_HEADERS));
        map.from(properties::getMaxCookies).to(serverOptions.option(UndertowOptions.MAX_COOKIES));
        this.mapSlashProperties(properties, serverOptions);
        map.from(properties::isDecodeUrl).to(serverOptions.option(UndertowOptions.DECODE_URL));
        map.from(properties::getUrlCharset).as(Charset::name).to(serverOptions.option(UndertowOptions.URL_CHARSET));
        map.from(properties::isAlwaysSetKeepAlive).to(serverOptions.option(UndertowOptions.ALWAYS_SET_KEEP_ALIVE));
        map.from(properties::getNoRequestTimeout).asInt(Duration::toMillis).to(serverOptions.option(UndertowOptions.NO_REQUEST_TIMEOUT));
        map.from(properties.getOptions()::getServer).to(serverOptions.forEach(serverOptions::option));
        SocketOptions socketOptions = new SocketOptions(factory);
        map.from(properties.getOptions()::getSocket).to(socketOptions.forEach(socketOptions::option));
    }

    private void mapSlashProperties(ServerProperties.Undertow properties, ServerOptions serverOptions) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::isAllowEncodedSlash).to(serverOptions.option(UndertowOptions.ALLOW_ENCODED_SLASH));
        map.from(properties::getDecodeSlash).to(serverOptions.option(UndertowOptions.DECODE_SLASH));
    }

    private boolean isPositive(Number value) {
        return value.longValue() > 0L;
    }

    private void mapAccessLogProperties(ConfigurableUndertowWebServerFactory factory) {
        ServerProperties.Undertow.Accesslog properties = this.serverProperties.getUndertow().getAccesslog();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(properties::isEnabled).to(factory::setAccessLogEnabled);
        map.from(properties::getDir).to(factory::setAccessLogDirectory);
        map.from(properties::getPattern).to(factory::setAccessLogPattern);
        map.from(properties::getPrefix).to(factory::setAccessLogPrefix);
        map.from(properties::getSuffix).to(factory::setAccessLogSuffix);
        map.from(properties::isRotate).to(factory::setAccessLogRotate);
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private static class ServerOptions
    extends AbstractOptions {
        ServerOptions(ConfigurableUndertowWebServerFactory factory) {
            super(UndertowOptions.class, factory);
        }

        <T> Consumer<T> option(Option<T> option) {
            return value -> this.getFactory().addBuilderCustomizers(builder -> builder.setServerOption(option, value));
        }
    }

    private static class SocketOptions
    extends AbstractOptions {
        SocketOptions(ConfigurableUndertowWebServerFactory factory) {
            super(Options.class, factory);
        }

        <T> Consumer<T> option(Option<T> option) {
            return value -> this.getFactory().addBuilderCustomizers(builder -> builder.setSocketOption(option, value));
        }
    }

    private static abstract class AbstractOptions {
        private final Class<?> source;
        private final Map<String, Option<?>> nameLookup;
        private final ConfigurableUndertowWebServerFactory factory;

        AbstractOptions(Class<?> source, ConfigurableUndertowWebServerFactory factory) {
            HashMap lookup = new HashMap();
            ReflectionUtils.doWithLocalFields(source, field -> {
                int modifiers = field.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Option.class.isAssignableFrom(field.getType())) {
                    try {
                        Option option = (Option)field.get(null);
                        lookup.put(AbstractOptions.getCanonicalName(field.getName()), option);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            });
            this.source = source;
            this.nameLookup = Collections.unmodifiableMap(lookup);
            this.factory = factory;
        }

        protected ConfigurableUndertowWebServerFactory getFactory() {
            return this.factory;
        }

        <T> Consumer<Map<String, String>> forEach(Function<Option<T>, Consumer<T>> function) {
            return map -> map.forEach((? super K key, ? super V value) -> {
                Option<?> option = this.nameLookup.get(AbstractOptions.getCanonicalName(key));
                Assert.state(option != null, () -> "Unable to find '" + key + "' in " + ClassUtils.getShortName(this.source));
                Object parsed = option.parseValue(value, this.getClass().getClassLoader());
                ((Consumer)function.apply(option)).accept(parsed);
            });
        }

        private static String getCanonicalName(String name) {
            StringBuilder canonicalName = new StringBuilder(name.length());
            name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach((int c) -> canonicalName.append((char)c));
            return canonicalName.toString();
        }
    }
}

