/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.task;

import java.util.concurrent.Executor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.task.TaskExecutionProperties;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.task.SimpleAsyncTaskExecutorBuilder;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.boot.task.TaskExecutorCustomizer;
import org.springframework.boot.task.ThreadPoolTaskExecutorBuilder;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

class TaskExecutorConfigurations {
    TaskExecutorConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    static class SimpleAsyncTaskExecutorBuilderConfiguration {
        private final TaskExecutionProperties properties;
        private final ObjectProvider<SimpleAsyncTaskExecutorCustomizer> taskExecutorCustomizers;
        private final ObjectProvider<TaskDecorator> taskDecorator;

        SimpleAsyncTaskExecutorBuilderConfiguration(TaskExecutionProperties properties, ObjectProvider<SimpleAsyncTaskExecutorCustomizer> taskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            this.properties = properties;
            this.taskExecutorCustomizers = taskExecutorCustomizers;
            this.taskDecorator = taskDecorator;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.PLATFORM)
        SimpleAsyncTaskExecutorBuilder simpleAsyncTaskExecutorBuilder() {
            return this.builder();
        }

        @Bean(name={"simpleAsyncTaskExecutorBuilder"})
        @ConditionalOnMissingBean
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskExecutorBuilder simpleAsyncTaskExecutorBuilderVirtualThreads() {
            SimpleAsyncTaskExecutorBuilder builder = this.builder();
            builder = builder.virtualThreads(true);
            return builder;
        }

        private SimpleAsyncTaskExecutorBuilder builder() {
            SimpleAsyncTaskExecutorBuilder builder = new SimpleAsyncTaskExecutorBuilder();
            builder = builder.threadNamePrefix(this.properties.getThreadNamePrefix());
            builder = builder.customizers(this.taskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator(this.taskDecorator.getIfUnique());
            TaskExecutionProperties.Simple simple = this.properties.getSimple();
            builder = builder.concurrencyLimit(simple.getConcurrencyLimit());
            TaskExecutionProperties.Shutdown shutdown = this.properties.getShutdown();
            if (shutdown.isAwaitTermination()) {
                builder = builder.taskTerminationTimeout(shutdown.getAwaitTerminationPeriod());
            }
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ThreadPoolTaskExecutorBuilderConfiguration {
        ThreadPoolTaskExecutorBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TaskExecutorBuilder.class, ThreadPoolTaskExecutorBuilder.class})
        ThreadPoolTaskExecutorBuilder threadPoolTaskExecutorBuilder(TaskExecutionProperties properties, ObjectProvider<ThreadPoolTaskExecutorCustomizer> threadPoolTaskExecutorCustomizers, ObjectProvider<TaskExecutorCustomizer> taskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            TaskExecutionProperties.Pool pool = properties.getPool();
            ThreadPoolTaskExecutorBuilder builder = new ThreadPoolTaskExecutorBuilder();
            builder = builder.queueCapacity(pool.getQueueCapacity());
            builder = builder.corePoolSize(pool.getCoreSize());
            builder = builder.maxPoolSize(pool.getMaxSize());
            builder = builder.allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout());
            builder = builder.keepAlive(pool.getKeepAlive());
            builder = builder.acceptTasksAfterContextClose(pool.getShutdown().isAcceptTasksAfterContextClose());
            TaskExecutionProperties.Shutdown shutdown = properties.getShutdown();
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.customizers(threadPoolTaskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator(taskDecorator.getIfUnique());
            builder = builder.additionalCustomizers(taskExecutorCustomizers.orderedStream().map(this::adapt).toList());
            return builder;
        }

        private ThreadPoolTaskExecutorCustomizer adapt(TaskExecutorCustomizer customizer2) {
            return customizer2::customize;
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class TaskExecutorBuilderConfiguration {
        TaskExecutorBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Deprecated(since="3.2.0", forRemoval=true)
        TaskExecutorBuilder taskExecutorBuilder(TaskExecutionProperties properties, ObjectProvider<TaskExecutorCustomizer> taskExecutorCustomizers, ObjectProvider<TaskDecorator> taskDecorator) {
            TaskExecutionProperties.Pool pool = properties.getPool();
            TaskExecutorBuilder builder = new TaskExecutorBuilder();
            builder = builder.queueCapacity(pool.getQueueCapacity());
            builder = builder.corePoolSize(pool.getCoreSize());
            builder = builder.maxPoolSize(pool.getMaxSize());
            builder = builder.allowCoreThreadTimeOut(pool.isAllowCoreThreadTimeout());
            builder = builder.keepAlive(pool.getKeepAlive());
            TaskExecutionProperties.Shutdown shutdown = properties.getShutdown();
            builder = builder.awaitTermination(shutdown.isAwaitTermination());
            builder = builder.awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod());
            builder = builder.threadNamePrefix(properties.getThreadNamePrefix());
            builder = builder.customizers(taskExecutorCustomizers.orderedStream()::iterator);
            builder = builder.taskDecorator(taskDecorator.getIfUnique());
            return builder;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Executor.class})
    static class TaskExecutorConfiguration {
        TaskExecutorConfiguration() {
        }

        @Bean(name={"applicationTaskExecutor", "taskExecutor"})
        @ConditionalOnThreading(value=Threading.VIRTUAL)
        SimpleAsyncTaskExecutor applicationTaskExecutorVirtualThreads(SimpleAsyncTaskExecutorBuilder builder) {
            return builder.build();
        }

        @Lazy
        @Bean(name={"applicationTaskExecutor", "taskExecutor"})
        @ConditionalOnThreading(value=Threading.PLATFORM)
        ThreadPoolTaskExecutor applicationTaskExecutor(TaskExecutorBuilder taskExecutorBuilder, ObjectProvider<ThreadPoolTaskExecutorBuilder> threadPoolTaskExecutorBuilderProvider) {
            ThreadPoolTaskExecutorBuilder threadPoolTaskExecutorBuilder = threadPoolTaskExecutorBuilderProvider.getIfUnique();
            if (threadPoolTaskExecutorBuilder != null) {
                return threadPoolTaskExecutorBuilder.build();
            }
            return taskExecutorBuilder.build();
        }
    }
}

