/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.spi;

import com.ctrip.framework.apollo.spring.annotation.ApolloAnnotationProcessor;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.SpringValueProcessor;
import com.ctrip.framework.apollo.spring.config.PropertySourcesProcessor;
import com.ctrip.framework.apollo.spring.property.AutoUpdateConfigChangeListener;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinitionProcessor;
import com.ctrip.framework.apollo.spring.spi.ApolloConfigRegistrarHelper;
import com.ctrip.framework.apollo.spring.util.BeanRegistrationUtil;
import com.google.common.collect.Lists;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class DefaultApolloConfigRegistrarHelper
implements ApolloConfigRegistrarHelper {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApolloConfigRegistrarHelper.class);
    private Environment environment;

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap(importingClassMetadata.getAnnotationAttributes(EnableApolloConfig.class.getName()));
        String[] namespaces = attributes.getStringArray("value");
        int order = (Integer)attributes.getNumber("order");
        String[] resolvedNamespaces = this.resolveNamespaces(namespaces);
        PropertySourcesProcessor.addNamespaces(Lists.newArrayList(resolvedNamespaces), order);
        HashMap<String, Object> propertySourcesPlaceholderPropertyValues = new HashMap<String, Object>();
        propertySourcesPlaceholderPropertyValues.put("order", 0);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesPlaceholderConfigurer.class, propertySourcesPlaceholderPropertyValues);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, AutoUpdateConfigChangeListener.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, ApolloAnnotationProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueDefinitionProcessor.class);
    }

    private String[] resolveNamespaces(String[] namespaces) {
        if (this.environment == null) {
            this.logNamespacePlaceholderNotSupportedMessage(namespaces);
            return namespaces;
        }
        String[] resolvedNamespaces = new String[namespaces.length];
        for (int i = 0; i < namespaces.length; ++i) {
            resolvedNamespaces[i] = this.environment.resolveRequiredPlaceholders(namespaces[i]);
        }
        return resolvedNamespaces;
    }

    private void logNamespacePlaceholderNotSupportedMessage(String[] namespaces) {
        for (String namespace : namespaces) {
            if (!namespace.contains("${")) continue;
            logger.warn("Namespace placeholder {} is not supported for Spring version prior to 3.2.x, see https://github.com/apolloconfig/apollo/issues/4178 for more details.", (Object)namespace);
            break;
        }
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }
}

