/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.ConfigFileChangeListener;
import com.ctrip.framework.apollo.PropertiesCompatibleConfigFile;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.internals.AbstractConfigRepository;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.model.ConfigFileChangeEvent;
import com.google.common.base.Preconditions;
import java.util.Properties;

public class PropertiesCompatibleFileConfigRepository
extends AbstractConfigRepository
implements ConfigFileChangeListener {
    private final PropertiesCompatibleConfigFile configFile;
    private volatile Properties cachedProperties;

    public PropertiesCompatibleFileConfigRepository(PropertiesCompatibleConfigFile configFile) {
        this.configFile = configFile;
        this.configFile.addChangeListener(this);
        this.trySync();
    }

    @Override
    protected synchronized void sync() {
        Properties current = this.configFile.asProperties();
        Preconditions.checkState(current != null, "PropertiesCompatibleConfigFile.asProperties should never return null");
        if (this.cachedProperties != current) {
            this.cachedProperties = current;
            this.fireRepositoryChange(this.configFile.getNamespace(), this.cachedProperties);
        }
    }

    @Override
    public Properties getConfig() {
        if (this.cachedProperties == null) {
            this.sync();
        }
        return this.cachedProperties;
    }

    @Override
    public void setUpstreamRepository(ConfigRepository upstreamConfigRepository) {
    }

    @Override
    public ConfigSourceType getSourceType() {
        return this.configFile.getSourceType();
    }

    @Override
    public void onChange(ConfigFileChangeEvent changeEvent) {
        this.trySync();
    }
}

