/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sdk;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.shenyu.common.utils.VersionUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.core.ShenyuInstanceRegisterRepositoryFactory;
import org.apache.shenyu.sdk.core.client.ShenyuSdkClient;
import org.apache.shenyu.sdk.core.client.ShenyuSdkClientFactory;
import org.apache.shenyu.sdk.core.interceptor.ShenyuSdkRequestInterceptor;
import org.apache.shenyu.sdk.spring.annotation.CookieValueParameterProcessor;
import org.apache.shenyu.sdk.spring.annotation.PathVariableParameterProcessor;
import org.apache.shenyu.sdk.spring.annotation.RequestBodyParameterProcessor;
import org.apache.shenyu.sdk.spring.annotation.RequestHeaderParameterProcessor;
import org.apache.shenyu.sdk.spring.annotation.RequestParamParameterProcessor;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.apache.shenyu.sdk.spring.factory.Contract;
import org.apache.shenyu.sdk.spring.support.SpringMvcContract;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"shenyu.sdk.enabled"}, havingValue="true", matchIfMissing=true)
public class ShenyuSdkAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Contract springMvcContract() {
        return new SpringMvcContract();
    }

    @Bean
    public ShenyuSdkClient shenyuSdkClient(RegisterConfig config, ObjectProvider<List<ShenyuSdkRequestInterceptor>> requestInterceptorsProvider, ObjectProvider<ShenyuInstanceRegisterRepository> instanceRegisterRepositoryProvider) {
        Properties props = config.getProps();
        String clientType = props.getProperty("clientType", "httpclient");
        ShenyuSdkClient shenyuSdkClient = ShenyuSdkClientFactory.newInstance((String)clientType);
        shenyuSdkClient.init(config, (List)requestInterceptorsProvider.getIfAvailable(), (ShenyuInstanceRegisterRepository)instanceRegisterRepositoryProvider.getIfAvailable());
        return shenyuSdkClient;
    }

    @Bean
    public ShenyuInstanceRegisterRepository shenyuInstanceRegisterRepository(RegisterConfig config) {
        String registerType = config.getRegisterType();
        if ("local".equals(registerType)) {
            return null;
        }
        return ShenyuInstanceRegisterRepositoryFactory.newAndInitInstance((RegisterConfig)config);
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sdk")
    public RegisterConfig shenyuConfig() {
        return new RegisterConfig();
    }

    static {
        VersionUtils.checkDuplicate(ShenyuSdkAutoConfiguration.class);
    }

    @Configuration(proxyBeanMethods=false)
    public static class ParameterProcessorRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            ArrayList<Object> annotatedParameterProcessors = new ArrayList<Object>();
            annotatedParameterProcessors.add(new CookieValueParameterProcessor());
            annotatedParameterProcessors.add(new PathVariableParameterProcessor());
            annotatedParameterProcessors.add(new RequestHeaderParameterProcessor());
            annotatedParameterProcessors.add(new RequestParamParameterProcessor());
            annotatedParameterProcessors.add(new RequestBodyParameterProcessor());
            for (AnnotatedParameterProcessor annotatedParameterProcessor : annotatedParameterProcessors) {
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(annotatedParameterProcessor.getClass());
                beanDefinition.setAutowireCandidate(true);
                beanDefinition.setRole(2);
                registry.registerBeanDefinition(annotatedParameterProcessor.getClass().getSimpleName(), (BeanDefinition)beanDefinition);
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

