/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.client.springmvc;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.auto.config.ClientRegisterConfiguration;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.ClientRegisterConfigImpl;
import org.apache.shenyu.client.springmvc.init.SpringMvcClientEventListener;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.VersionUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.springboot.starter.client.common.config.ShenyuClientCommonBeanConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

@Configuration
@ImportAutoConfiguration(value={ShenyuClientCommonBeanConfiguration.class})
@ConditionalOnProperty(value={"shenyu.register.enabled"}, matchIfMissing=true, havingValue="true")
public class ShenyuSpringMvcClientConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ClientRegisterConfiguration.class})
    public SpringMvcClientEventListener springHttpClientEventListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository, Environment env) {
        ShenyuClientConfig.ClientPropertiesConfig clientPropertiesConfig = (ShenyuClientConfig.ClientPropertiesConfig)clientConfig.getClient().get(RpcTypeEnum.HTTP.getName());
        Properties props = Optional.ofNullable(clientPropertiesConfig).map(PropertiesConfig::getProps).orElse(null);
        String applicationName = env.getProperty("spring.application.name");
        String discoveryMode = env.getProperty("shenyu.discovery.type", "local");
        if (Objects.nonNull(props)) {
            String contextPath;
            String appName = props.getProperty("appName");
            if (StringUtils.isBlank((CharSequence)appName) && StringUtils.isBlank((CharSequence)applicationName)) {
                throw new IllegalArgumentException("spring.application.name or shenyu.client.http.props.appName must not be empty");
            }
            if (StringUtils.isBlank((CharSequence)appName)) {
                props.setProperty("appName", applicationName);
            }
            if (StringUtils.isBlank((CharSequence)(contextPath = props.getProperty("contextPath")))) {
                props.setProperty("contextPath", String.format("/%s", applicationName));
            }
            props.setProperty("discoveryLocalMode", Boolean.valueOf("local".equals(discoveryMode)).toString());
        }
        return new SpringMvcClientEventListener(clientConfig, shenyuClientRegisterRepository, env);
    }

    @Bean(value={"springMvcClientRegisterConfig"})
    @Primary
    public ClientRegisterConfig clientRegisterConfig(ShenyuClientConfig shenyuClientConfig, ApplicationContext applicationContext, Environment env) {
        return new ClientRegisterConfigImpl(shenyuClientConfig, RpcTypeEnum.HTTP, applicationContext, env);
    }

    static {
        VersionUtils.checkDuplicate(ShenyuSpringMvcClientConfiguration.class);
    }
}

