/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.client.spring.websocket;

import jakarta.annotation.Resource;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.register.ClientDiscoveryConfigRefreshedEventListener;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.InstanceRegisterListener;
import org.apache.shenyu.client.spring.websocket.init.SpringWebSocketClientEventListener;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.register.client.http.HttpClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.config.ShenyuDiscoveryConfig;
import org.apache.shenyu.springboot.starter.client.common.config.ShenyuClientCommonBeanConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ImportAutoConfiguration(value={ShenyuClientCommonBeanConfiguration.class})
public class ShenyuSpringWebSocketDiscoveryConfiguration {
    @Resource
    private Environment environment;

    @Bean(value={"WebSocketClientDiscoveryConfigRefreshedEventListener"})
    @ConditionalOnProperty(prefix="shenyu.discovery", name={"serverList"}, matchIfMissing=false)
    @ConditionalOnBean(value={ShenyuDiscoveryConfig.class})
    public ClientDiscoveryConfigRefreshedEventListener clientDiscoveryConfigRefreshedEventListener(ShenyuDiscoveryConfig shenyuDiscoveryConfig, HttpClientRegisterRepository httpClientRegisterRepository, ClientRegisterConfig clientRegisterConfig, ShenyuClientConfig shenyuClientConfig) {
        return new ClientDiscoveryConfigRefreshedEventListener(shenyuDiscoveryConfig, httpClientRegisterRepository, clientRegisterConfig, PluginEnum.WEB_SOCKET, shenyuClientConfig);
    }

    @Bean(value={"websocketInstanceRegisterListener"})
    @ConditionalOnBean(value={ShenyuDiscoveryConfig.class})
    @ConditionalOnProperty(prefix="shenyu.discovery", name={"register"}, matchIfMissing=false)
    public InstanceRegisterListener instanceRegisterListener(SpringWebSocketClientEventListener eventListener, ShenyuDiscoveryConfig shenyuDiscoveryConfig, ShenyuClientConfig shenyuClientConfig) {
        DiscoveryUpstreamData discoveryUpstreamData = new DiscoveryUpstreamData();
        discoveryUpstreamData.setProtocol("ws://");
        discoveryUpstreamData.setStatus(0);
        discoveryUpstreamData.setWeight(50);
        discoveryUpstreamData.setUrl(eventListener.getHost() + ":" + eventListener.getPort());
        discoveryUpstreamData.setNamespaceId(shenyuClientConfig.getNamespace());
        String appName = this.environment.getProperty("spring.application.name");
        if (StringUtils.isEmpty((CharSequence)shenyuDiscoveryConfig.getProps().getProperty("name")) && Objects.nonNull(appName)) {
            shenyuDiscoveryConfig.getProps().put("name", appName);
        }
        return new InstanceRegisterListener(discoveryUpstreamData, shenyuDiscoveryConfig);
    }
}

