/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.client.motan;

import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import org.apache.shenyu.client.motan.MotanServiceEventListener;
import org.apache.shenyu.common.utils.VersionUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.springboot.starter.client.common.config.ShenyuClientCommonBeanConfiguration;
import org.apache.shenyu.springboot.starter.client.motan.property.RegistryConfig;
import org.apache.shenyu.springboot.starter.client.motan.property.ShenyuMotanConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

@Configuration
@ImportAutoConfiguration(value={ShenyuClientCommonBeanConfiguration.class})
@ConditionalOnProperty(value={"shenyu.register.enabled"}, matchIfMissing=true, havingValue="true")
public class ShenyuMotanClientConfiguration
implements ApplicationListener<ContextRefreshedEvent> {
    @Bean
    public MotanServiceEventListener motanServiceEventListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        return new MotanServiceEventListener(clientConfig, shenyuClientRegisterRepository);
    }

    @Bean
    @ConfigurationProperties(prefix="motan.registry")
    public RegistryConfig registryProperties() {
        return new RegistryConfig();
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.client.motan")
    public ShenyuMotanConfig shenyuMotanProperties() {
        return new ShenyuMotanConfig();
    }

    @Bean
    public AnnotationBean motanAnnotationBean(@Value(value="${shenyu.client.motan.package-path}") String packagePath) {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        motanAnnotationBean.setPackage(packagePath);
        return motanAnnotationBean;
    }

    @Bean(value={"motan2"})
    public ProtocolConfigBean protocolConfig(ShenyuMotanConfig shenyuMotanConfig) {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(shenyuMotanConfig.getProtocol().isDefault());
        config.setName("motan2");
        config.setMaxContentLength(shenyuMotanConfig.getProtocol().getMaxContentLength());
        return config;
    }

    @Bean(value={"motan"})
    public ProtocolConfigBean motanProtocolConfig(ShenyuMotanConfig shenyuMotanConfig) {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(shenyuMotanConfig.getProtocol().isDefault());
        config.setName("motan");
        config.setMaxContentLength(shenyuMotanConfig.getProtocol().getMaxContentLength());
        return config;
    }

    @Bean
    public RegistryConfigBean registryConfig(RegistryConfig registryConfig) {
        RegistryConfigBean config = new RegistryConfigBean();
        config.setRegProtocol(registryConfig.getProtocol());
        config.setAddress(registryConfig.getAddress());
        return config;
    }

    @Bean
    public BasicServiceConfigBean baseServiceConfig(ShenyuMotanConfig shenyuMotanConfig) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setExport(String.format("%s:%s", shenyuMotanConfig.getProtocol().getName(), shenyuMotanConfig.getBasicServiceConfig().getExportPort()));
        config.setGroup(shenyuMotanConfig.getBasicServiceConfig().getGroup());
        config.setAccessLog(shenyuMotanConfig.getBasicServiceConfig().isAccessLog());
        config.setShareChannel(Boolean.valueOf(shenyuMotanConfig.getBasicServiceConfig().isShareChannel()));
        config.setModule(shenyuMotanConfig.getBasicServiceConfig().getModule());
        config.setApplication(shenyuMotanConfig.getBasicServiceConfig().getApplication());
        config.setRegistry(shenyuMotanConfig.getBasicServiceConfig().getRegistry());
        config.setRequestTimeout(shenyuMotanConfig.getBasicServiceConfig().getRequestTimeout());
        return config;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ShenyuMotanConfig shenyuMotanConfig = (ShenyuMotanConfig)event.getApplicationContext().getBean(ShenyuMotanConfig.class);
        MotanSwitcherUtil.setSwitcherValue((String)"feature.configserver.heartbeat", (boolean)shenyuMotanConfig.getBasicServiceConfig().getRegistryHeartBeatSwitcher());
    }

    static {
        VersionUtils.checkDuplicate(ShenyuMotanClientConfiguration.class);
    }
}

