/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.sdk.spring.ShenyuClientFactoryBean;
import org.apache.shenyu.sdk.spring.proxy.ShenyuClientInvocationHandler;
import org.springframework.context.ApplicationContext;

public final class ShenyuClientProxyFactory {
    private static final ConcurrentMap<Class<?>, Object> PROXY_CACHE = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createProxy(Class<?> apiClass, ApplicationContext applicationContext, ShenyuClientFactoryBean shenyuClientFactoryBean) {
        if (!apiClass.isInterface()) {
            throw new UnsupportedOperationException("@ShenyuClient please use it on the interface. " + apiClass.getName());
        }
        if (PROXY_CACHE.containsKey(apiClass)) {
            return PROXY_CACHE.get(apiClass);
        }
        Class<?> clazz = apiClass;
        synchronized (clazz) {
            Object proxy = Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)new ShenyuClientInvocationHandler(apiClass, applicationContext, shenyuClientFactoryBean));
            PROXY_CACHE.put(apiClass, proxy);
        }
        return PROXY_CACHE.get(apiClass);
    }
}

