/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.annotation;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.core.util.Util;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.CookieValue;

public class CookieValueParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<CookieValue> ANNOTATION = CookieValue.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(ShenyuRequest shenyuRequest, Annotation annotation, Object arg) {
        RequestTemplate requestTemplate = shenyuRequest.getRequestTemplate();
        CookieValue cookie = ANNOTATION.cast(annotation);
        String name = cookie.value().trim();
        Util.checkState((boolean)StringUtils.isNotBlank((CharSequence)name), (String)"Cookie.name() was empty on parameter %s", (Object[])new Object[]{requestTemplate.getMethod()});
        Collection cookieExpression = requestTemplate.getHeaders().getOrDefault("Cookie", Lists.newArrayList());
        cookieExpression.add(String.format("%s=%s", name, arg));
        Map headers = shenyuRequest.getHeaders();
        headers.compute("Cookie", (key, old) -> {
            if (CollectionUtils.isEmpty((Collection)old)) {
                return cookieExpression;
            }
            CollectionUtils.addAll((Collection)old, (Iterable)cookieExpression);
            return old;
        });
        shenyuRequest.setHeaders(headers);
        return true;
    }
}

