/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.okhttp;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.ShenyuResponse;
import org.apache.shenyu.sdk.core.client.AbstractShenyuSdkClient;
import org.apache.shenyu.spi.Join;

@Join
public class OkHttpShenyuSdkClient
extends AbstractShenyuSdkClient {
    private OkHttpClient okHttpClient;

    protected void initClient(Properties props) {
        String maxIdleConnections = props.getProperty("http.maxIdleConnections", "200");
        String keepAliveDuration = props.getProperty("http.keepAliveDuration", "2");
        String connectTimeout = props.getProperty("http.connectTimeout", "60");
        String readTimeout = props.getProperty("http.readTimeout", "60");
        this.okHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectionPool(this.pool(Integer.parseInt(maxIdleConnections), Long.parseLong(keepAliveDuration))).connectTimeout(Long.parseLong(connectTimeout), TimeUnit.SECONDS).readTimeout(Long.parseLong(readTimeout), TimeUnit.SECONDS).build();
    }

    protected ShenyuResponse doRequest(ShenyuRequest request) throws IOException {
        String url = request.getUrl();
        String body = request.getBody();
        Map headers = request.getHeaders();
        Request.Builder builder = new Request.Builder().url(url);
        for (String name2 : headers.keySet()) {
            for (String value : (Collection)headers.get(name2)) {
                builder.addHeader(name2, value);
            }
        }
        RequestBody requestBody = StringUtils.isNotBlank((CharSequence)request.getBody()) ? RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=UTF-8"), (String)body) : Util.EMPTY_REQUEST;
        switch (request.getHttpMethod()) {
            case GET: {
                builder = builder.get();
                break;
            }
            case HEAD: {
                builder = builder.head();
                break;
            }
            case POST: {
                builder = builder.post(requestBody);
                break;
            }
            case PUT: {
                builder = builder.put(requestBody);
                break;
            }
            case DELETE: {
                builder = builder.delete(requestBody);
                break;
            }
            case OPTIONS: {
                builder.method("OPTIONS", requestBody);
                break;
            }
            case TRACE: {
                builder.method("TRACE", requestBody);
                break;
            }
            default: {
                builder.patch(requestBody);
            }
        }
        Request okhttpRequest = builder.build();
        try (Response okhttpResponse = this.okHttpClient.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = okhttpResponse.body();
            String bodyStr = Objects.isNull(responseBody) ? null : responseBody.string();
            ShenyuResponse shenyuResponse = new ShenyuResponse(okhttpResponse.code(), null, okhttpResponse.headers().names().stream().collect(Collectors.toMap(name -> name, name -> okhttpResponse.headers().values(name))), bodyStr, request);
            return shenyuResponse;
        }
    }

    private ConnectionPool pool(int maxIdleConnections, long keepAliveDuration) {
        return new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.MINUTES);
    }
}

