/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.feign;

import feign.Capability;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.sdk.feign.EnableShenyuClients;
import org.apache.shenyu.sdk.feign.ShenyuClient;
import org.apache.shenyu.sdk.feign.ShenyuClientCapability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ShenyuClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClientsRegistrar.class);
    private ResourceLoader resourceLoader;
    private Environment environment;

    ShenyuClientsRegistrar() {
    }

    static void validateFallback(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback class must implement the interface annotated by @ShenyuClient");
    }

    static void validateFallbackFactory(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback factory must produce instances of fallback classes that implement the interface annotated by @ShenyuClient");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        this.registerDefaultConfiguration(metadata, registry);
        this.registerShenyuClients(metadata, registry);
    }

    private void registerDefaultConfiguration(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map defaultAttrs = metadata.getAnnotationAttributes(EnableShenyuClients.class.getName(), true);
        if (MapUtils.isNotEmpty((Map)defaultAttrs) && defaultAttrs.containsKey("defaultConfiguration")) {
            String name = metadata.hasEnclosingClass() ? "default." + metadata.getEnclosingClassName() : "default." + metadata.getClassName();
            LOG.info("registerDefaultConfiguration name:{}", (Object)name);
            this.registerClientConfiguration(registry, name, defaultAttrs.get("defaultConfiguration"));
        }
    }

    public void registerShenyuClients(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        LinkedHashSet<AnnotatedGenericBeanDefinition> candidateComponents = new LinkedHashSet<AnnotatedGenericBeanDefinition>();
        Map attrs = metadata.getAnnotationAttributes(EnableShenyuClients.class.getName());
        Class[] clients = Objects.isNull(attrs) ? null : (Class[])attrs.get("clients");
        LOG.info("clients:{}", (Object)JsonUtils.toJson((Object)clients));
        if (Objects.isNull(clients) || clients.length == 0) {
            ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
            scanner.setResourceLoader(this.resourceLoader);
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ShenyuClient.class));
            Set<String> set = this.getBasePackages(metadata);
            LOG.info("basePackages:{}", (Object)JsonUtils.toJson(set));
            for (String basePackage : set) {
                candidateComponents.addAll(scanner.findCandidateComponents(basePackage));
            }
        } else {
            for (Class clazz : clients) {
                candidateComponents.add(new AnnotatedGenericBeanDefinition(clazz));
            }
        }
        for (BeanDefinition beanDefinition : candidateComponents) {
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition beanDefinition2 = (AnnotatedBeanDefinition)beanDefinition;
            AnnotationMetadata annotationMetadata = beanDefinition2.getMetadata();
            Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)("@ShenyuClient can only be specified on an interface " + beanDefinition.getBeanClassName()));
            Map attributes = annotationMetadata.getAnnotationAttributes(ShenyuClient.class.getCanonicalName());
            String name = this.getClientName(attributes);
            LOG.info("configuration, attributes:{}", (Object)JsonUtils.toJson((Object)attributes));
            this.registerShenyuClient(registry, annotationMetadata, attributes);
        }
    }

    private void registerShenyuClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        String className = annotationMetadata.getClassName();
        ConfigurableBeanFactory beanFactory = registry instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)registry : null;
        String name = this.getName(attributes);
        String contextId = this.getContextId(beanFactory, attributes);
        Class clazz = ClassUtils.resolveClassName((String)className, null);
        FeignClientFactoryBean factoryBean = new FeignClientFactoryBean();
        factoryBean.setBeanFactory((BeanFactory)beanFactory);
        factoryBean.setName(name);
        factoryBean.setContextId(contextId);
        factoryBean.setType(clazz);
        factoryBean.setRefreshableClient(this.isClientRefreshEnabled());
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz, () -> {
            Object fallbackFactory;
            factoryBean.setUrl(name);
            factoryBean.setPath(this.getPath(beanFactory, attributes));
            factoryBean.setDismiss404(Boolean.parseBoolean(String.valueOf(attributes.get("dismiss404"))));
            Object fallback = attributes.get("fallback");
            if (Objects.nonNull(fallback)) {
                factoryBean.setFallback(fallback instanceof Class ? (Class)fallback : ClassUtils.resolveClassName((String)fallback.toString(), null));
            }
            if (Objects.nonNull(fallbackFactory = attributes.get("fallbackFactory"))) {
                factoryBean.setFallbackFactory(fallbackFactory instanceof Class ? (Class)fallbackFactory : ClassUtils.resolveClassName((String)fallbackFactory.toString(), null));
            }
            factoryBean.addCustomizer(builder -> {
                ConfigurableBeanFactory factory = beanFactory;
                if (Objects.isNull(beanFactory)) {
                    factory = factoryBean.getApplicationContext();
                }
                ShenyuClientCapability.INSTANCE.setBeanFactory((BeanFactory)factory);
                builder.addCapability((Capability)ShenyuClientCapability.INSTANCE);
            });
            return factoryBean.getObject();
        });
        definition.setAutowireMode(2);
        definition.setLazyInit(true);
        this.validate(attributes);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)className);
        beanDefinition.setAttribute("shenyuClientsRegistrarFactoryBean", (Object)factoryBean);
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        Object[] qualifiers = this.getQualifiers(attributes);
        if (ObjectUtils.isEmpty((Object[])qualifiers)) {
            qualifiers = new String[]{name + "ShenyuClient"};
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, (String[])qualifiers);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    private void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        ShenyuClientsRegistrar.validateFallback(annotation.getClass("fallback"));
        ShenyuClientsRegistrar.validateFallbackFactory(annotation.getClass("fallbackFactory"));
    }

    private String getContextId(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String contextId = (String)attributes.get("contextId");
        if (!StringUtils.hasText((String)contextId)) {
            return this.getName(attributes);
        }
        contextId = this.resolve(beanFactory, contextId);
        return ShenyuClientsRegistrar.getName(contextId);
    }

    private String resolve(ConfigurableBeanFactory beanFactory, String value) {
        if (StringUtils.hasText((String)value)) {
            if (Objects.isNull(beanFactory)) {
                return this.environment.resolvePlaceholders(value);
            }
            BeanExpressionResolver resolver = beanFactory.getBeanExpressionResolver();
            String resolved = beanFactory.resolveEmbeddedValue(value);
            if (Objects.isNull(resolver)) {
                return resolved;
            }
            Object evaluateValue = resolver.evaluate(resolved, new BeanExpressionContext(beanFactory, null));
            if (Objects.nonNull(evaluateValue)) {
                return String.valueOf(evaluateValue);
            }
            return null;
        }
        return value;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                boolean isCandidate = false;
                if (beanDefinition.getMetadata().isIndependent() && !beanDefinition.getMetadata().isAnnotation()) {
                    isCandidate = true;
                }
                return isCandidate;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableShenyuClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    private String getQualifier(Map<String, Object> client) {
        if (Objects.isNull(client)) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    private String[] getQualifiers(Map<String, Object> client) {
        if (Objects.isNull(client)) {
            return null;
        }
        List<String> qualifierList = new ArrayList<String>(Arrays.asList((String[])client.get("qualifiers")));
        qualifierList.removeIf(qualifier -> !StringUtils.hasText((String)qualifier));
        if (qualifierList.isEmpty() && Objects.nonNull(this.getQualifier(client))) {
            qualifierList = Collections.singletonList(this.getQualifier(client));
        }
        return !qualifierList.isEmpty() ? qualifierList.toArray(new String[0]) : null;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    static String getName(String name) {
        String host;
        if (!StringUtils.hasText((String)name)) {
            return "";
        }
        try {
            Object url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI((String)url).getHost();
        }
        catch (URISyntaxException e) {
            host = null;
        }
        Assert.state((boolean)Objects.nonNull(host), (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    String getName(Map<String, Object> attributes) {
        return this.getName(null, attributes);
    }

    String getName(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String name = (String)attributes.get("name");
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        name = this.resolve(beanFactory, name);
        return ShenyuClientsRegistrar.getName(name);
    }

    static String getUrl(String url) {
        Object resultUrl = url;
        if (!(!StringUtils.hasText((String)resultUrl) || ((String)resultUrl).startsWith("#{") && ((String)resultUrl).contains("}"))) {
            if (!((String)resultUrl).contains("://")) {
                resultUrl = "http://" + (String)resultUrl;
            }
            if (((String)resultUrl).endsWith("/")) {
                resultUrl = ((String)resultUrl).substring(0, ((String)resultUrl).length() - 1);
            }
            try {
                new URL((String)resultUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException((String)resultUrl + " is malformed", e);
            }
        }
        return resultUrl;
    }

    private String getUrl(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String url = this.resolve(beanFactory, (String)attributes.get("url"));
        return ShenyuClientsRegistrar.getUrl(url);
    }

    private String getPath(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String path = this.resolve(beanFactory, (String)attributes.get("path"));
        return ShenyuClientsRegistrar.getPath(path);
    }

    static String getPath(String path) {
        Object resultPath = path;
        if (StringUtils.hasText((String)resultPath)) {
            if (!((String)(resultPath = ((String)resultPath).trim())).startsWith("/")) {
                resultPath = "/" + (String)resultPath;
            }
            if (((String)resultPath).endsWith("/")) {
                resultPath = ((String)resultPath).substring(0, ((String)resultPath).length() - 1);
            }
        }
        return resultPath;
    }

    private String getClientName(Map<String, Object> client) {
        if (Objects.isNull(client)) {
            return null;
        }
        String value = (String)client.get("contextId");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("value");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("serviceId");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + FeignClient.class.getSimpleName());
    }

    private void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FeignClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + "." + FeignClientSpecification.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }

    private boolean isClientRefreshEnabled() {
        return (Boolean)this.environment.getProperty("feign.client.refresh-enabled", Boolean.class, (Object)false);
    }
}

