/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.Objects;
import org.apache.shenyu.protocol.mqtt.MessageType;

public class MqttFactory {
    private final MessageType messageType = new MessageType();
    private final MqttMessage msg;
    private final ChannelHandlerContext ctx;

    public MqttFactory(MqttMessage msg, ChannelHandlerContext ctx) {
        this.msg = msg;
        this.ctx = ctx;
    }

    public void connect() {
        if (Objects.isNull(this.msg.fixedHeader())) {
            return;
        }
        switch (this.msg.fixedHeader().messageType()) {
            case CONNECT: {
                this.messageType.connect(this.ctx, (MqttConnectMessage)this.msg);
                break;
            }
            case PUBLISH: {
                this.messageType.publish(this.ctx, (MqttPublishMessage)this.msg);
                break;
            }
            case SUBSCRIBE: {
                this.messageType.subscribe(this.ctx, (MqttSubscribeMessage)this.msg);
                break;
            }
            case UNSUBSCRIBE: {
                this.messageType.unsubscribe(this.ctx, (MqttUnsubscribeMessage)this.msg);
                break;
            }
            case PINGREQ: {
                this.messageType.pingReq(this.ctx);
                break;
            }
        }
    }
}

