/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.waf;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.WafHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.WafEnum;
import org.apache.shenyu.common.enums.WafModelEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.waf.config.WafConfig;
import org.apache.shenyu.plugin.waf.handler.WafPluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WafPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(WafPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        WafConfig wafConfig = (WafConfig)Singleton.INST.get(WafConfig.class);
        if (Objects.isNull(selector) && Objects.isNull(rule)) {
            if (WafModelEnum.BLACK.getName().equals(wafConfig.getModel())) {
                return chain.execute(exchange);
            }
            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)HttpStatus.FORBIDDEN.value(), (String)" You are forbidden to visit", null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        WafHandle wafHandle = this.buildRuleHandle(rule);
        if (Objects.isNull(wafHandle) || StringUtils.isBlank((CharSequence)wafHandle.getPermission())) {
            LOG.error("waf handler can not configuration\uff1a{}", (Object)wafHandle);
            return chain.execute(exchange);
        }
        if (WafEnum.REJECT.getName().equals(wafHandle.getPermission())) {
            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)Integer.parseInt(wafHandle.getStatusCode()), (String)" You are forbidden to visit", null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.execute(exchange);
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return this.doExecute(exchange, chain, null, null);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return this.doExecute(exchange, chain, null, null);
    }

    public String named() {
        return PluginEnum.WAF.getName();
    }

    public int getOrder() {
        return PluginEnum.WAF.getCode();
    }

    private WafHandle buildRuleHandle(RuleData rule) {
        return (WafHandle)WafPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
    }
}

