/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.cache;

import com.alipay.sofa.rpc.api.GenericService;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.context.AsyncRuntime;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.concurrent.ShenyuThreadPoolExecutor;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.SofaRegisterConfig;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public final class ApplicationConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private final ThreadFactory factory = ShenyuThreadFactory.create((String)"shenyu-sofa", (boolean)true);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ThreadPoolExecutor threadPool;
    private final LoadingCache<String, ConsumerConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        if (Objects.nonNull(notification.getValue())) {
            try {
                Class<?> cz = notification.getValue().getClass();
                Field field = FieldUtils.getDeclaredField(cz, (String)"consumerBootstrap", (boolean)true);
                FieldUtils.writeField((Field)field, (Object)notification.getValue(), null);
            }
            catch (IllegalAccessException e) {
                LOG.error("modify ref have exception", (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ConsumerConfig<GenericService>>(){

        @NonNull
        public ConsumerConfig<GenericService> load(@NonNull String key) {
            return new ConsumerConfig();
        }
    });

    private ApplicationConfigCache() {
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(SofaRegisterConfig sofaRegisterConfig) {
        String shenyuProxy = "shenyu_proxy";
        if (Objects.isNull(this.applicationConfig)) {
            this.applicationConfig = new ApplicationConfig();
            this.applicationConfig.setAppId("shenyu_proxy");
            this.applicationConfig.setAppName("shenyu_proxy");
        }
        if (Objects.isNull(this.registryConfig)) {
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setProtocol(sofaRegisterConfig.getProtocol());
            this.registryConfig.setId("shenyu_proxy");
            this.registryConfig.setRegister(false);
            this.registryConfig.setAddress(sofaRegisterConfig.getRegister());
        }
        if (StringUtils.isNotBlank((CharSequence)sofaRegisterConfig.getThreadpool())) {
            this.initThreadPool(sofaRegisterConfig);
            Optional.ofNullable(this.threadPool).ifPresent(this::setAsyncRuntimeThreadPool);
        }
    }

    private void setAsyncRuntimeThreadPool(ThreadPoolExecutor threadPool) {
        Field field = ReflectionUtils.findField(AsyncRuntime.class, (String)"asyncThreadPool");
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, AsyncRuntime.class, (Object)threadPool);
    }

    private void initThreadPool(SofaRegisterConfig config) {
        if (Objects.nonNull(this.threadPool)) {
            return;
        }
        switch (config.getThreadpool()) {
            case "shared": {
                try {
                    this.threadPool = (ThreadPoolExecutor)SpringBeanUtils.getInstance().getBean(ShenyuThreadPoolExecutor.class);
                    return;
                }
                catch (NoSuchBeanDefinitionException t) {
                    throw new ShenyuException("shared thread pool is not enable, config ${shenyu.sharedPool.enable} in your xml/yml !", (Throwable)t);
                }
            }
            case "fixed": 
            case "eager": 
            case "limited": {
                throw new UnsupportedOperationException();
            }
            case "cached": {
                int corePoolSize = Optional.ofNullable(config.getCorethreads()).orElse(0);
                int maximumPoolSize = Optional.ofNullable(config.getThreads()).orElse(Integer.MAX_VALUE);
                int queueSize = Optional.ofNullable(config.getQueues()).orElse(0);
                this.threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new SynchronousQueue())), this.factory);
                return;
            }
        }
    }

    public ConsumerConfig<GenericService> initRef(MetaData metaData) {
        try {
            ConsumerConfig referenceConfig = (ConsumerConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterfaceId()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init sofa ref ex:{}", (Object)e.getMessage());
        }
        return this.build(metaData);
    }

    public ConsumerConfig<GenericService> build(MetaData metaData) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ConsumerConfig();
        }
        ConsumerConfig reference = new ConsumerConfig();
        reference.setGeneric(true);
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterfaceId(metaData.getServiceName());
        reference.setProtocol("bolt");
        reference.setInvokeType("callback");
        reference.setRepeatedReferLimit(-1);
        String rpcExt = metaData.getRpcExt();
        SofaParamExtInfo sofaParamExtInfo = (SofaParamExtInfo)GsonUtils.getInstance().fromJson(rpcExt, SofaParamExtInfo.class);
        if (Objects.nonNull(sofaParamExtInfo)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sofaParamExtInfo.getLoadbalance()})) {
                String loadBalance = sofaParamExtInfo.getLoadbalance();
                reference.setLoadBalancer(this.buildLoadBalanceName(loadBalance));
            }
            Optional.ofNullable(sofaParamExtInfo.getTimeout()).ifPresent(arg_0 -> ((ConsumerConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(sofaParamExtInfo.getRetries()).ifPresent(arg_0 -> ((ConsumerConfig)reference).setRetries(arg_0));
        }
        try {
            Object obj = reference.refer();
            if (Objects.nonNull(obj)) {
                LOG.info("init sofa reference success there meteData is :{}", (Object)metaData);
                this.cache.put((Object)metaData.getPath(), (Object)reference);
            }
        }
        catch (Exception e) {
            LOG.error("init sofa reference exception", (Throwable)e);
        }
        return reference;
    }

    private String buildLoadBalanceName(String loadBalance) {
        if (LoadBalanceEnum.HASH.getName().equals(loadBalance) || StringUtils.equalsIgnoreCase((CharSequence)"consistenthash", (CharSequence)loadBalance)) {
            return "consistentHash";
        }
        if (LoadBalanceEnum.ROUND_ROBIN.getName().equals(loadBalance) || StringUtils.equalsIgnoreCase((CharSequence)"roundrobin", (CharSequence)loadBalance)) {
            return "roundRobin";
        }
        return loadBalance;
    }

    public ConsumerConfig<GenericService> get(String path) {
        try {
            return (ConsumerConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }

    static class SofaParamExtInfo {
        private String loadbalance;
        private Integer retries;
        private Integer timeout;

        SofaParamExtInfo() {
        }

        public String getLoadbalance() {
            return this.loadbalance;
        }

        public void setLoadbalance(String loadbalance) {
            this.loadbalance = loadbalance;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }
    }
}

