/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.request;

import com.google.gson.JsonObject;
import org.apache.shenyu.common.utils.GsonUtils;

public class RequestConfigHelper {
    private final JsonObject configJson;

    public RequestConfigHelper(String requestConfig) {
        this.configJson = (JsonObject)GsonUtils.getInstance().fromJson(requestConfig, JsonObject.class);
    }

    public JsonObject getRequestTemplate() {
        return this.configJson.getAsJsonObject("requestTemplate");
    }

    public JsonObject getArgsPosition() {
        return this.configJson.has("argsPosition") ? this.configJson.getAsJsonObject("argsPosition") : new JsonObject();
    }

    public JsonObject getResponseTemplate() {
        return this.configJson.has("responseTemplate") ? this.configJson.getAsJsonObject("responseTemplate") : null;
    }

    public String getUrlTemplate() {
        return this.getRequestTemplate().get("url").getAsString();
    }

    public String getMethod() {
        JsonObject requestTemplate = this.getRequestTemplate();
        return requestTemplate.has("method") ? requestTemplate.get("method").getAsString() : "GET";
    }

    public boolean isArgsToJsonBody() {
        JsonObject requestTemplate = this.getRequestTemplate();
        return requestTemplate.has("argsToJsonBody") && requestTemplate.get("argsToJsonBody").getAsBoolean();
    }

    public static String buildPath(String urlTemplate, JsonObject argsPosition, JsonObject inputJson) {
        if (RequestConfigHelper.isCompleteUrl(argsPosition, inputJson)) {
            return RequestConfigHelper.getCompleteUrl(argsPosition, inputJson);
        }
        StringBuilder queryBuilder = new StringBuilder();
        boolean hasExistingQuery = urlTemplate.contains("?");
        String basePath = hasExistingQuery ? urlTemplate.substring(0, urlTemplate.indexOf("?")) : urlTemplate;
        String existingQuery = hasExistingQuery ? urlTemplate.substring(urlTemplate.indexOf("?") + 1) : "";
        basePath = RequestConfigHelper.processArguments(argsPosition, inputJson, basePath, queryBuilder);
        basePath = basePath.replaceAll("\\{\\{\\.[^}]+}}", "");
        return RequestConfigHelper.buildFinalPath(basePath, queryBuilder, hasExistingQuery, existingQuery);
    }

    private static boolean isCompleteUrl(JsonObject argsPosition, JsonObject inputJson) {
        for (String key : argsPosition.keySet()) {
            if (!inputJson.has(key)) continue;
            try {
                String value = inputJson.get(key).getAsString();
                if (!value.startsWith("http://") && !value.startsWith("https://") && !value.contains("?")) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private static String getCompleteUrl(JsonObject argsPosition, JsonObject inputJson) {
        for (String key : argsPosition.keySet()) {
            if (!inputJson.has(key)) continue;
            try {
                String value = inputJson.get(key).getAsString();
                if (!value.startsWith("http://") && !value.startsWith("https://") && !value.contains("?")) continue;
                return value;
            }
            catch (Exception exception) {
            }
        }
        return "";
    }

    private static String processArguments(JsonObject argsPosition, JsonObject inputJson, String basePath, StringBuilder queryBuilder) {
        String modifiedBasePath = basePath;
        for (String key : argsPosition.keySet()) {
            String value;
            String position = argsPosition.get(key).getAsString();
            if ("path".equals(position) && inputJson.has(key)) {
                value = inputJson.get(key).getAsString();
                if (value.contains("?")) {
                    value = value.substring(0, value.indexOf("?"));
                }
                value = value.replace("\"", "").trim();
                modifiedBasePath = modifiedBasePath.replace("{{." + key + "}}", value);
                continue;
            }
            if (!"query".equals(position) || !inputJson.has(key) || modifiedBasePath.contains(key + "=")) continue;
            if (!queryBuilder.isEmpty()) {
                queryBuilder.append("&");
            }
            if ((value = inputJson.get(key).getAsString()).contains("?")) {
                value = value.substring(0, value.indexOf("?"));
            }
            value = value.replace("\"", "").trim();
            queryBuilder.append(key).append("=").append(value);
        }
        return modifiedBasePath;
    }

    private static String buildFinalPath(String basePath, StringBuilder queryBuilder, boolean hasExistingQuery, String existingQuery) {
        String result;
        StringBuilder finalPath = new StringBuilder(basePath);
        if (!queryBuilder.isEmpty()) {
            if (hasExistingQuery) {
                finalPath.append("&").append((CharSequence)queryBuilder);
            } else {
                finalPath.append("?").append((CharSequence)queryBuilder);
            }
        }
        if (hasExistingQuery && !existingQuery.isEmpty()) {
            if (!queryBuilder.isEmpty()) {
                finalPath.append("&").append(existingQuery);
            } else {
                finalPath.append("?").append(existingQuery);
            }
        }
        if ((result = finalPath.toString()).endsWith("?")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

