/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.rabbitmq.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.logging.rabbitmq.client.RabbitmqLogCollectClient;
import org.apache.shenyu.plugin.logging.rabbitmq.config.RabbitmqLogCollectConfig;

public class RabbitmqClientCache {
    private static final Map<String, RabbitmqLogCollectClient> CLIENT_CACHE = Maps.newConcurrentMap();

    public static RabbitmqClientCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void initRabbitmqClient(String selectorId, RabbitmqLogCollectConfig.LogApiConfig rabbitmqLogUpstream) {
        RabbitmqLogCollectConfig.RabbitmqLogConfig globalLogConfig = (RabbitmqLogCollectConfig.RabbitmqLogConfig)((Object)Singleton.INST.get(RabbitmqLogCollectConfig.RabbitmqLogConfig.class));
        if (Objects.nonNull((Object)rabbitmqLogUpstream) && Objects.nonNull(rabbitmqLogUpstream.getHost())) {
            globalLogConfig = RabbitmqClientCache.copyConfig(rabbitmqLogUpstream);
        }
        RabbitmqLogCollectClient rabbitmqLogCollectClient = new RabbitmqLogCollectClient();
        rabbitmqLogCollectClient.initClient(globalLogConfig);
        CLIENT_CACHE.put(selectorId, rabbitmqLogCollectClient);
    }

    public RabbitmqLogCollectClient getRabbitmqClient(String path) {
        return CLIENT_CACHE.get(path);
    }

    public Map<String, RabbitmqLogCollectClient> getClientCache() {
        return CLIENT_CACHE;
    }

    public void invalidate(String path) {
        RabbitmqLogCollectClient client = CLIENT_CACHE.get(path);
        if (Objects.nonNull((Object)client)) {
            client.close();
            CLIENT_CACHE.remove(path);
        }
    }

    public void invalidateAll() {
        if (CLIENT_CACHE.isEmpty()) {
            return;
        }
        CLIENT_CACHE.values().forEach(client -> {
            try {
                if (Objects.nonNull(client)) {
                    client.close();
                }
            }
            catch (Exception e) {
                ShenyuPlugin.LOG.error("Failed to close client {}", (Object)client, (Object)e);
            }
        });
        CLIENT_CACHE.clear();
    }

    public static RabbitmqLogCollectConfig.RabbitmqLogConfig copyConfig(RabbitmqLogCollectConfig.LogApiConfig rabbitmqLogUpstream) {
        RabbitmqLogCollectConfig.RabbitmqLogConfig rabbitmqLogConfig = new RabbitmqLogCollectConfig.RabbitmqLogConfig();
        rabbitmqLogConfig.setQueueName(rabbitmqLogUpstream.getQueueName());
        rabbitmqLogConfig.setHost(rabbitmqLogUpstream.getHost());
        rabbitmqLogConfig.setPort(rabbitmqLogUpstream.getPort());
        rabbitmqLogConfig.setUsername(rabbitmqLogUpstream.getUsername());
        rabbitmqLogConfig.setPassword(rabbitmqLogUpstream.getPassword());
        rabbitmqLogConfig.setRoutingKey(rabbitmqLogUpstream.getRoutingKey());
        rabbitmqLogConfig.setExchangeName(rabbitmqLogUpstream.getExchangeName());
        rabbitmqLogConfig.setExchangeType(rabbitmqLogUpstream.getExchangeType());
        rabbitmqLogConfig.setVirtualHost(rabbitmqLogUpstream.getVirtualHost());
        rabbitmqLogConfig.setExclusive(rabbitmqLogUpstream.getExclusive());
        rabbitmqLogConfig.setDurable(rabbitmqLogUpstream.getDurable());
        rabbitmqLogConfig.setAutoDelete(rabbitmqLogUpstream.getAutoDelete());
        rabbitmqLogConfig.setArgs(rabbitmqLogUpstream.getArgs());
        return rabbitmqLogConfig;
    }

    static final class ApplicationConfigCacheInstance {
        static final RabbitmqClientCache INSTANCE = new RabbitmqClientCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

