/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.plugin;

import java.util.List;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.exception.ResponsiveException;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.utils.ServerWebExchangeUtils;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.plugin.AbstractCryptorPlugin;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CryptorRequestPlugin
extends AbstractCryptorPlugin {
    private final List<HttpMessageReader<?>> messageReaders;

    public CryptorRequestPlugin(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    @Override
    protected Mono<Void> doExecute0(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule, CryptorRuleHandler ruleHandle) {
        return ServerWebExchangeUtils.rewriteRequestBody((ServerWebExchange)exchange, this.messageReaders, originalBody -> Mono.just((Object)this.convert((String)originalBody, ruleHandle, exchange))).flatMap(arg_0 -> ((ShenyuPluginChain)chain).execute(arg_0)).onErrorResume(error -> {
            if (error instanceof ResponsiveException) {
                return WebFluxResultUtils.failedResult((ResponsiveException)((ResponsiveException)error));
            }
            return Mono.error((Throwable)error);
        });
    }

    @Override
    protected ShenyuResultEnum checkErrorEnum() {
        return ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION;
    }

    @Override
    protected String fieldErrorParse(String originalBody, ServerWebExchange exchange) {
        throw new ResponsiveException(ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getCode(), ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getMsg() + "[fieldNames]", exchange);
    }

    public int getOrder() {
        return PluginEnum.CRYPTOR_REQUEST.getCode();
    }

    public String named() {
        return PluginEnum.CRYPTOR_REQUEST.getName();
    }
}

