/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.fallback;

import java.net.URI;
import java.util.Objects;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface FallbackHandler {
    public static final String PREFIX = "fallback:";

    public Mono<Void> withoutFallback(ServerWebExchange var1, Throwable var2);

    default public Mono<Void> fallback(ServerWebExchange exchange, URI uri, Throwable t) {
        boolean isSameUri;
        if (t instanceof HttpStatusCodeException || Objects.isNull(uri)) {
            return this.withoutFallback(exchange, t);
        }
        if (uri.toString().startsWith(PREFIX)) {
            String fallbackPath = uri.toString().substring(PREFIX.length());
            DispatcherHandler dispatcherHandler = (DispatcherHandler)SpringBeanUtils.getInstance().getBean(DispatcherHandler.class);
            URI previsouUri = exchange.getRequest().getURI();
            if (UriUtils.getPathWithParams((URI)previsouUri).equals(fallbackPath)) {
                return this.withoutFallback(exchange, t);
            }
            URI fallbackUri = UriUtils.createUri((String)previsouUri.getScheme(), (String)previsouUri.getAuthority(), (String)fallbackPath);
            ServerHttpRequest request = exchange.getRequest().mutate().uri(fallbackUri).build();
            ServerWebExchange mutated = exchange.mutate().request(request).build();
            return dispatcherHandler.handle(mutated);
        }
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        if (Objects.nonNull(uri.getScheme())) {
            isSameUri = request.getURI().toString().equals(uri.toString());
        } else {
            String uriStr = UriUtils.repairData((String)uri.toString());
            isSameUri = uriStr.equals(UriUtils.getPathWithParams((URI)request.getURI()));
        }
        if (isSameUri) {
            return this.withoutFallback(exchange, t);
        }
        response.setStatusCode((HttpStatusCode)HttpStatus.FOUND);
        response.getHeaders().setLocation(uri);
        return Mono.empty();
    }
}

