/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.trie;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.RuleData;

public class ShenyuTrieNode
implements Serializable {
    private static final long serialVersionUID = -2347426887850566364L;
    private String matchStr;
    private String fullPath;
    private Cache<String, ShenyuTrieNode> children;
    private Cache<String, ShenyuTrieNode> pathVariablesSet;
    private ShenyuTrieNode pathVariableNode;
    private boolean isWildcard;
    private boolean endOfPath;
    private Cache<String, List<RuleData>> pathRuleCache;
    private Object bizInfo;

    public ShenyuTrieNode() {
    }

    public ShenyuTrieNode(String matchStr, String fullPath, boolean endOfPath, Long childrenSize, Long pathRuleCacheSize, Long pathVariableSize) {
        this.matchStr = matchStr;
        this.fullPath = fullPath;
        this.endOfPath = endOfPath;
        this.children = Caffeine.newBuilder().maximumSize(childrenSize.longValue()).build();
        this.pathRuleCache = Caffeine.newBuilder().maximumSize(pathRuleCacheSize.longValue()).build();
        this.pathVariablesSet = Caffeine.newBuilder().maximumSize(pathVariableSize.longValue()).build();
    }

    public String getMatchStr() {
        return this.matchStr;
    }

    public void setMatchStr(String matchStr) {
        this.matchStr = matchStr;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public Cache<String, ShenyuTrieNode> getChildren() {
        return this.children;
    }

    public Cache<String, ShenyuTrieNode> getPathVariablesSet() {
        return this.pathVariablesSet;
    }

    public void setPathVariablesSet(Cache<String, ShenyuTrieNode> pathVariablesSet) {
        this.pathVariablesSet = pathVariablesSet;
    }

    public ShenyuTrieNode getPathVariableNode() {
        return this.pathVariableNode;
    }

    public void setPathVariableNode(ShenyuTrieNode pathVariableNode) {
        this.pathVariableNode = pathVariableNode;
    }

    public void setChildren(Cache<String, ShenyuTrieNode> children) {
        this.children = children;
    }

    public boolean getWildcard() {
        return this.isWildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.isWildcard = wildcard;
    }

    public boolean getEndOfPath() {
        return this.endOfPath;
    }

    public void setEndOfPath(boolean endOfPath) {
        this.endOfPath = endOfPath;
    }

    public Object getBizInfo() {
        return this.bizInfo;
    }

    public void setBizInfo(Object bizInfo) {
        this.bizInfo = bizInfo;
    }

    public Cache<String, List<RuleData>> getPathRuleCache() {
        return this.pathRuleCache;
    }

    public void setPathRuleCache(Cache<String, List<RuleData>> pathRuleCache) {
        this.pathRuleCache = pathRuleCache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShenyuTrieNode that = (ShenyuTrieNode)o;
        return this.isWildcard == that.isWildcard && this.endOfPath == that.endOfPath && this.matchStr.equals(that.matchStr) && this.fullPath.equals(that.fullPath) && this.children.equals(that.children) && this.pathVariablesSet.equals(that.pathVariablesSet) && this.pathVariableNode.equals(that.pathVariableNode) && this.pathRuleCache.equals(that.pathRuleCache) && this.bizInfo.equals(that.bizInfo);
    }

    public int hashCode() {
        return Objects.hash(this.matchStr, this.fullPath, this.children, this.pathVariablesSet, this.pathVariableNode, this.isWildcard, this.endOfPath, this.pathRuleCache, this.bizInfo);
    }

    public String toString() {
        return "ShenyuTrieNode{matchStr='" + this.matchStr + '\'' + ", fullPath='" + this.fullPath + '\'' + ", children=" + this.children + ", pathVariablesSet=" + this.pathVariablesSet + ", pathVariableNode=" + this.pathVariableNode + ", isWildcard=" + this.isWildcard + ", endOfPath=" + this.endOfPath + ", pathRuleCache=" + this.pathRuleCache + ", bizInfo=" + this.bizInfo + '}';
    }
}

