/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.cache.MemorySafeWindowTinyLFUMap;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;

public final class MatchDataCache {
    private static final MatchDataCache INSTANCE = new MatchDataCache();
    private static final ConcurrentMap<String, Map<String, SelectorData>> SELECTOR_DATA_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, Map<String, RuleData>> RULE_DATA_MAP = Maps.newConcurrentMap();

    private MatchDataCache() {
    }

    public static MatchDataCache getInstance() {
        return INSTANCE;
    }

    public void removeSelectorData(String pluginName) {
        SELECTOR_DATA_MAP.remove(pluginName);
    }

    public void cleanSelectorData() {
        SELECTOR_DATA_MAP.clear();
    }

    public void cacheSelectorData(String path, SelectorData selectorData, Integer maxMemory) {
        SELECTOR_DATA_MAP.computeIfAbsent(selectorData.getPluginName(), map -> new MemorySafeWindowTinyLFUMap(maxMemory.intValue(), 65536)).put(path, selectorData);
    }

    public SelectorData obtainSelectorData(String pluginName, String path) {
        Map lruMap = (Map)SELECTOR_DATA_MAP.get(pluginName);
        return (SelectorData)Optional.ofNullable(lruMap).orElse(Maps.newHashMap()).get(path);
    }
}

