/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.condition.strategy.MatchStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractShenyuPlugin
implements ShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShenyuPlugin.class);
    private static final String URI_CONDITION_TYPE = "uri";
    private ShenyuConfig.MatchCache matchCacheConfig;

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4);

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        this.initMatchCacheConfig();
        String pluginName = this.named();
        PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(pluginName);
        if (pluginData != null && pluginData.getEnabled().booleanValue()) {
            String path = exchange.getRequest().getURI().getPath();
            SelectorData selectorData = this.obtainSelectorDataCacheIfEnabled(exchange);
            if (Objects.isNull(selectorData)) {
                List<SelectorData> selectors = BaseDataCache.getInstance().obtainSelectorData(pluginName);
                if (CollectionUtils.isEmpty(selectors)) {
                    return this.handleSelectorIfNull(pluginName, exchange, chain);
                }
                Pair<Boolean, SelectorData> matchSelectorData = this.matchSelector(exchange, selectors);
                selectorData = (SelectorData)matchSelectorData.getRight();
                if (((Boolean)matchSelectorData.getLeft()).booleanValue()) {
                    this.cacheSelectorDataIfEnabled(path, selectorData);
                }
            }
            if (Objects.isNull(selectorData)) {
                return this.handleSelectorIfNull(pluginName, exchange, chain);
            }
            this.selectorLog(selectorData, pluginName);
            List<RuleData> rules = BaseDataCache.getInstance().obtainRuleData(selectorData.getId());
            if (CollectionUtils.isEmpty(rules)) {
                return this.handleRuleIfNull(pluginName, exchange, chain);
            }
            RuleData rule = selectorData.getType().intValue() == SelectorTypeEnum.FULL_FLOW.getCode() ? rules.get(rules.size() - 1) : this.matchRule(exchange, rules);
            if (Objects.isNull(rule)) {
                return this.handleRuleIfNull(pluginName, exchange, chain);
            }
            this.ruleLog(rule, pluginName);
            return this.doExecute(exchange, chain, selectorData, rule);
        }
        return chain.execute(exchange);
    }

    private void initMatchCacheConfig() {
        if (Objects.isNull(this.matchCacheConfig)) {
            this.matchCacheConfig = ((ShenyuConfig)SpringBeanUtils.getInstance().getBean(ShenyuConfig.class)).getMatchCache();
        }
    }

    private void cacheSelectorDataIfEnabled(String path, SelectorData selectorData) {
        boolean isUriCondition;
        List conditionList;
        if (this.matchCacheConfig.getEnabled() && Objects.nonNull(selectorData) && CollectionUtils.isNotEmpty((Collection)(conditionList = selectorData.getConditionList())) && (isUriCondition = conditionList.stream().allMatch(v -> URI_CONDITION_TYPE.equals(v.getParamType())))) {
            MatchDataCache.getInstance().cacheSelectorData(path, selectorData, this.getMaxFreeMemory());
        }
    }

    private Integer getMaxFreeMemory() {
        return this.matchCacheConfig.getMaxFreeMemory() * 1024 * 1024;
    }

    private SelectorData obtainSelectorDataCacheIfEnabled(ServerWebExchange exchange) {
        if (this.matchCacheConfig.getEnabled()) {
            return MatchDataCache.getInstance().obtainSelectorData(this.named(), exchange.getRequest().getURI().getPath());
        }
        return null;
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    private Pair<Boolean, SelectorData> matchSelector(ServerWebExchange exchange, Collection<SelectorData> selectors) {
        List<SelectorData> filterCollectors = selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, exchange) != false).collect(Collectors.toList());
        if (filterCollectors.size() > 1) {
            return Pair.of((Object)Boolean.FALSE, (Object)this.manyMatchSelector(filterCollectors));
        }
        return Pair.of((Object)Boolean.TRUE, filterCollectors.stream().findFirst().orElse(null));
    }

    private SelectorData manyMatchSelector(List<SelectorData> filterCollectors) {
        Map<Integer, List<Pair>> collect = filterCollectors.stream().map(selector -> {
            boolean match = MatchModeEnum.match((Integer)selector.getMatchMode(), (MatchModeEnum)MatchModeEnum.AND);
            int sort = 0;
            if (match) {
                sort = selector.getConditionList().size();
            }
            return Pair.of((Object)sort, (Object)selector);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        Integer max = Collections.max(collect.keySet());
        List<Pair> pairs = collect.get(max);
        return pairs.stream().map(Pair::getRight).min(Comparator.comparing(SelectorData::getSort)).orElse(null);
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyFactory.match(selector.getMatchMode(), selector.getConditionList(), exchange);
        }
        return true;
    }

    private RuleData matchRule(ServerWebExchange exchange, Collection<RuleData> rules) {
        return rules.stream().filter(rule -> this.filterRule((RuleData)rule, exchange)).findFirst().orElse(null);
    }

    private Boolean filterRule(RuleData ruleData, ServerWebExchange exchange) {
        return ruleData.getEnabled() != false && MatchStrategyFactory.match(ruleData.getMatchMode(), ruleData.getConditionDataList(), exchange);
    }

    private void selectorLog(SelectorData selectorData, String pluginName) {
        if (selectorData.getLogged().booleanValue()) {
            LOG.info("{} selector success match , selector name :{}", (Object)pluginName, (Object)selectorData.getName());
        }
    }

    private void ruleLog(RuleData ruleData, String pluginName) {
        if (ruleData.getLoged().booleanValue()) {
            LOG.info("{} rule success match , rule name :{}", (Object)pluginName, (Object)ruleData.getName());
        }
    }
}

