/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.fallback;

import java.net.URI;
import java.util.Objects;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface FallbackHandler {
    public Mono<Void> generateError(ServerWebExchange var1, Throwable var2);

    default public Mono<Void> fallback(ServerWebExchange exchange, URI uri, Throwable t) {
        if (Objects.isNull(uri)) {
            return this.generateError(exchange, t);
        }
        DispatcherHandler dispatcherHandler = (DispatcherHandler)SpringBeanUtils.getInstance().getBean(DispatcherHandler.class);
        ServerHttpRequest request = exchange.getRequest().mutate().uri(Objects.requireNonNull(uri)).build();
        ServerWebExchange mutated = exchange.mutate().request(request).build();
        return dispatcherHandler.handle(mutated);
    }
}

