/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.DubboRegisterConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboMethodParam;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheDubboConfigCache
extends DubboConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDubboConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private ConsumerConfig consumerConfig;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (Objects.nonNull(config)) {
            config.destroy();
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        @Nonnull
        public ReferenceConfig<GenericService> load(@Nonnull String key) {
            return new ReferenceConfig();
        }
    });

    public static ApacheDubboConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.applicationConfig)) {
            this.applicationConfig = new ApplicationConfig("shenyu_proxy");
        }
        if (this.needUpdateRegistryConfig(dubboRegisterConfig)) {
            RegistryConfig registryConfigTemp = new RegistryConfig();
            registryConfigTemp.setProtocol(dubboRegisterConfig.getProtocol());
            registryConfigTemp.setId("shenyu_proxy");
            registryConfigTemp.setRegister(Boolean.valueOf(false));
            registryConfigTemp.setAddress(dubboRegisterConfig.getRegister());
            Optional.ofNullable(dubboRegisterConfig.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setGroup(arg_0));
            this.registryConfig = registryConfigTemp;
        }
        if (Objects.isNull(this.consumerConfig)) {
            this.consumerConfig = new ConsumerConfig();
            this.consumerConfig.refresh();
            Optional.ofNullable(dubboRegisterConfig.getThreadpool()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setThreadpool(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getCorethreads()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setCorethreads(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getThreads()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setThreads(arg_0));
            Optional.ofNullable(dubboRegisterConfig.getQueues()).ifPresent(arg_0 -> ((ConsumerConfig)this.consumerConfig).setQueues(arg_0));
        }
    }

    private boolean needUpdateRegistryConfig(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.registryConfig)) {
            return true;
        }
        return !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol()) || !Objects.equals(dubboRegisterConfig.getRegister(), this.registryConfig.getAddress());
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData, "");
    }

    public ReferenceConfig<GenericService> initRefN(MetaData metaData, String namespace) {
        if (StringUtils.isBlank((CharSequence)namespace)) {
            return this.initRef(metaData);
        }
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)(namespace + ":" + metaData.getPath()));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("initRefN dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData, namespace);
    }

    public ReferenceConfig<GenericService> build(MetaData metaData, String namespace) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ReferenceConfig();
        }
        ReferenceConfig<GenericService> reference = this.buildReference(metaData, namespace);
        try {
            Object obj = reference.get();
            if (Objects.nonNull(obj)) {
                LOG.info("buildN init apache dubbo reference success there meteData is :{}", (Object)metaData);
                this.cache.put(StringUtils.isNotBlank((CharSequence)namespace) ? namespace + ":" + metaData.getPath() : metaData.getPath(), reference);
            }
        }
        catch (Exception e) {
            LOG.error("buildN init apache dubbo reference exception", (Throwable)e);
        }
        return reference;
    }

    private ReferenceConfig<GenericService> buildReference(MetaData metaData, String namespace) {
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        reference.setAsync(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setConsumer(this.consumerConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        reference.setCheck(Boolean.valueOf(false));
        reference.setLoadbalance("gray");
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("dispatcher", "direct");
        reference.setParameters(parameters);
        String rpcExt = metaData.getRpcExt();
        DubboParam dubboParam = this.parserToDubboParam(rpcExt);
        if (Objects.nonNull(dubboParam)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getVersion()})) {
                reference.setVersion(dubboParam.getVersion());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getGroup()})) {
                reference.setGroup(dubboParam.getGroup());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getUrl()})) {
                reference.setUrl(dubboParam.getUrl());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getCluster()})) {
                reference.setCluster(dubboParam.getCluster());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getLoadbalance()})) {
                reference.getParameters().put("dubboLoadBalance", dubboParam.getLoadbalance());
            }
            if ("protobuf".equals(dubboParam.getSerialization())) {
                reference.setGeneric("protobuf-json");
            }
            Optional.ofNullable(dubboParam.getProtocol()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setProtocol(arg_0));
            Optional.ofNullable(dubboParam.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(dubboParam.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
            Optional.ofNullable(dubboParam.getSent()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setSent(arg_0));
            if (CollectionUtils.isNotEmpty((Collection)dubboParam.getMethods())) {
                reference.setMethods(new ArrayList());
                for (DubboMethodParam dubboMethodParam : dubboParam.getMethods()) {
                    MethodConfig methodConfig = new MethodConfig();
                    methodConfig.setName(dubboMethodParam.getName());
                    methodConfig.setLoadbalance("gray");
                    methodConfig.setRetries(dubboMethodParam.getRetries());
                    methodConfig.setTimeout(dubboMethodParam.getTimeout());
                    methodConfig.setSent(dubboMethodParam.getSent());
                    HashMap<String, String> methodsParameters = new HashMap<String, String>(1);
                    methodsParameters.put("dubboLoadBalance", dubboMethodParam.getLoadbalance());
                    methodConfig.setParameters(methodsParameters);
                    reference.getMethods().add(methodConfig);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            RegistryConfig registryConfig = new RegistryConfig();
            registryConfig.setRegister(Boolean.valueOf(false));
            if (!this.registryConfig.getAddress().contains("namespace")) {
                registryConfig.setAddress(this.registryConfig.getAddress() + "?namespace=" + namespace);
                reference.setRegistry(registryConfig);
            } else {
                String newAddress = this.registryConfig.getAddress().substring(0, this.registryConfig.getAddress().indexOf("namespace") + 1) + "namespace=" + namespace;
                registryConfig.setAddress(newAddress);
                reference.setRegistry(registryConfig);
            }
        } else {
            reference.setRegistry(this.registryConfig);
        }
        return reference;
    }

    public ReferenceConfig<GenericService> get(String path) {
        try {
            return (ReferenceConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static final class ApplicationConfigCacheInstance {
        static final ApacheDubboConfigCache INSTANCE = new ApacheDubboConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

