/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.reconciler;

import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBuilder;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.ShenyuSniAsyncMapping;
import org.apache.shenyu.common.config.ssl.SslCrtAndKey;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.PluginRoleEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.k8s.cache.IngressCache;
import org.apache.shenyu.k8s.cache.IngressSecretCache;
import org.apache.shenyu.k8s.cache.IngressSelectorCache;
import org.apache.shenyu.k8s.cache.ServiceIngressCache;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.IngressParser;
import org.apache.shenyu.k8s.repository.ShenyuCacheRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngressReconciler
implements Reconciler {
    private static final Logger LOG = LoggerFactory.getLogger(IngressReconciler.class);
    private static Pair<Pair<String, String>, IngressConfiguration> globalDefaultBackend;
    private final Lister<V1Ingress> ingressLister;
    private final Lister<V1Secret> secretLister;
    private final ShenyuCacheRepository shenyuCacheRepository;
    private final ShenyuSniAsyncMapping shenyuSniAsyncMapping;
    private final IngressParser ingressParser;
    private final ApiClient apiClient;

    public IngressReconciler(SharedIndexInformer<V1Ingress> ingressInformer, SharedIndexInformer<V1Secret> secretInformer, ShenyuCacheRepository shenyuCacheRepository, ShenyuSniAsyncMapping shenyuSniAsyncMapping, IngressParser ingressParser, ApiClient apiClient) {
        this.ingressLister = new Lister(ingressInformer.getIndexer());
        this.secretLister = new Lister(secretInformer.getIndexer());
        this.shenyuCacheRepository = shenyuCacheRepository;
        this.shenyuSniAsyncMapping = shenyuSniAsyncMapping;
        this.ingressParser = ingressParser;
        this.apiClient = apiClient;
        this.initPlugins(shenyuCacheRepository);
    }

    public Result reconcile(Request request) {
        LOG.info("Starting to reconcile ingress {}", (Object)request);
        V1Ingress v1Ingress = (V1Ingress)this.ingressLister.namespace(request.getNamespace()).get(request.getName());
        V1Ingress oldIngress = IngressCache.getInstance().get(request.getNamespace(), request.getName());
        Map annotations = v1Ingress.getMetadata().getAnnotations();
        this.enablePluginsBasedOnAnnotations(annotations, request);
        if (Objects.isNull(v1Ingress)) {
            if (Objects.nonNull(oldIngress)) {
                this.doDeleteConfigByIngress(request, oldIngress);
                Set<String> sslDomainSet = IngressSecretCache.getInstance().getDomainByIngress(request.getNamespace(), request.getName());
                if (Objects.nonNull(sslDomainSet) && !sslDomainSet.isEmpty()) {
                    for (String sslDomain : sslDomainSet) {
                        Integer preDomainSslNums = IngressSecretCache.getInstance().getAndDecrementDomainNums(sslDomain);
                        if (preDomainSslNums != 1) continue;
                        this.shenyuSniAsyncMapping.removeSslCertificate(sslDomain);
                        LOG.info("Remove ssl config for domain {}", (Object)sslDomain);
                    }
                }
                IngressSecretCache.getInstance().removeDomainByIngress(request.getNamespace(), request.getName());
                IngressCache.getInstance().remove(request.getNamespace(), request.getName());
                LOG.info("Delete selector and rule for ingress {}", (Object)request);
            } else {
                LOG.info("Cannot find ingress {}", (Object)request);
            }
            return new Result(false);
        }
        if (!this.checkIngressClass(v1Ingress)) {
            LOG.info("IngressClass is not match {}", (Object)request);
            return new Result(false);
        }
        if (Objects.isNull(oldIngress)) {
            try {
                this.addNewIngressConfigToShenyu(v1Ingress, new CoreV1Api(this.apiClient));
            }
            catch (IOException e) {
                LOG.error("add new ingress config error", (Throwable)e);
            }
        } else if (this.needUpdate(oldIngress, v1Ingress)) {
            this.doDeleteConfigByIngress(request, oldIngress);
            try {
                this.addNewIngressConfigToShenyu(v1Ingress, new CoreV1Api(this.apiClient));
            }
            catch (IOException e) {
                LOG.error("add new ingress config error", (Throwable)e);
            }
        }
        IngressCache.getInstance().put(request.getNamespace(), request.getName(), v1Ingress);
        List<Pair<String, String>> serviceList = this.parseServiceFromIngress(v1Ingress);
        Objects.requireNonNull(serviceList).forEach(pair -> {
            ServiceIngressCache.getInstance().putIngressName((String)pair.getLeft(), (String)pair.getRight(), request.getNamespace(), request.getName());
            LOG.info("Add service cache {} for ingress {}", (Object)((String)pair.getLeft() + "/" + (String)pair.getRight()), (Object)(request.getNamespace() + "/" + request.getName()));
        });
        return new Result(false);
    }

    private void enablePluginsBasedOnAnnotations(Map<String, String> annotations, Request request) {
        if (Objects.equals(annotations.get("shenyu.apache.org/plugin-dubbo-enabled"), "true")) {
            String zookeeperUrl = this.getZookeeperUrl(annotations, request);
            this.enablePlugin(this.shenyuCacheRepository, PluginEnum.DUBBO, zookeeperUrl);
        } else if (Objects.equals(annotations.get("shenyu.apache.org/plugin-motan-enabled"), "true")) {
            String zookeeperUrl = this.getZookeeperUrl(annotations, request);
            this.enablePlugin(this.shenyuCacheRepository, PluginEnum.MOTAN, zookeeperUrl);
        } else if (Objects.equals(annotations.get("shenyu.apache.org/plugin-web-socket-enabled"), "true")) {
            this.enablePlugin(this.shenyuCacheRepository, PluginEnum.WEB_SOCKET, null);
        } else if (Objects.equals(annotations.get("shenyu.apache.org/plugin-grpc-enabled"), "true")) {
            this.enablePlugin(this.shenyuCacheRepository, PluginEnum.GRPC, null);
        } else if (Objects.equals(annotations.get("shenyu.apache.org/plugin-sofa-enabled"), "true")) {
            String zookeeperUrl = this.getZookeeperUrl(annotations, request);
            this.enablePlugin(this.shenyuCacheRepository, PluginEnum.SOFA, zookeeperUrl);
        }
    }

    private void doDeleteConfigByIngress(Request request, V1Ingress oldIngress) {
        List<Object> selectorList = new ArrayList();
        selectorList = Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-dubbo-enabled"), "true") ? this.deleteSelectorByIngressName(request.getNamespace(), request.getName(), PluginEnum.DUBBO.getName(), (String)oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-dubbo-context-path")) : (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-motan-enabled"), "true") ? this.deleteSelectorByIngressName(request.getNamespace(), request.getName(), PluginEnum.MOTAN.getName(), (String)oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-motan-context-path")) : (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-web-socket-enabled"), "true") ? this.deleteSelectorByIngressName(request.getNamespace(), request.getName(), PluginEnum.WEB_SOCKET.getName(), "") : (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-grpc-enabled"), "true") ? this.deleteSelectorByIngressName(request.getNamespace(), request.getName(), PluginEnum.GRPC.getName(), "") : (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-sofa-enabled"), "true") ? this.deleteSelectorByIngressName(request.getNamespace(), request.getName(), PluginEnum.SOFA.getName(), (String)oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-sofa-context-path")) : this.deleteSelectorByIngressName(request.getNamespace(), request.getName(), PluginEnum.DIVIDE.getName(), "")))));
        if (Objects.nonNull(selectorList) && !selectorList.isEmpty()) {
            if (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-dubbo-enabled"), "true")) {
                IngressSelectorCache.getInstance().remove(request.getNamespace(), request.getName(), PluginEnum.DUBBO.getName());
            } else if (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-motan-enabled"), "true")) {
                IngressSelectorCache.getInstance().remove(request.getNamespace(), request.getName(), PluginEnum.MOTAN.getName());
            } else if (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-web-socket-enabled"), "true")) {
                IngressSelectorCache.getInstance().remove(request.getNamespace(), request.getName(), PluginEnum.WEB_SOCKET.getName());
            } else if (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-grpc-enabled"), "true")) {
                IngressSelectorCache.getInstance().remove(request.getNamespace(), request.getName(), PluginEnum.GRPC.getName());
            } else if (Objects.equals(oldIngress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-sofa-enabled"), "true")) {
                IngressSelectorCache.getInstance().remove(request.getNamespace(), request.getName(), PluginEnum.SOFA.getName());
            } else {
                IngressSelectorCache.getInstance().remove(request.getNamespace(), request.getName(), PluginEnum.DIVIDE.getName());
            }
        }
        List<Pair<String, String>> serviceList = this.parseServiceFromIngress(oldIngress);
        Objects.requireNonNull(serviceList).forEach(pair -> {
            ServiceIngressCache.getInstance().removeSpecifiedIngressName((String)pair.getLeft(), (String)pair.getRight(), request.getNamespace(), request.getName());
            LOG.info("Delete service cache {} for ingress {}", (Object)((String)pair.getLeft() + "/" + (String)pair.getRight()), (Object)(request.getNamespace() + "/" + request.getName()));
        });
        this.deleteGlobalDefaultBackend(request.getNamespace(), request.getName());
    }

    private void deleteGlobalDefaultBackend(String namespace, String name) {
        if (Objects.nonNull(globalDefaultBackend) && (namespace + "/" + name).equals(((Pair)globalDefaultBackend.getLeft()).getLeft())) {
            globalDefaultBackend = null;
        }
    }

    private void initPlugins(ShenyuCacheRepository shenyuCacheRepository) {
        this.enablePlugin(shenyuCacheRepository, PluginEnum.GLOBAL, null);
        this.enablePlugin(shenyuCacheRepository, PluginEnum.URI, null);
        this.enablePlugin(shenyuCacheRepository, PluginEnum.NETTY_HTTP_CLIENT, null);
        this.enablePlugin(shenyuCacheRepository, PluginEnum.DIVIDE, null);
        this.enablePlugin(shenyuCacheRepository, PluginEnum.GENERAL_CONTEXT, null);
    }

    private void enablePlugin(ShenyuCacheRepository shenyuCacheRepository, PluginEnum pluginEnum, String zookeeperUrl) {
        PluginData pluginData = PluginData.builder().id(String.valueOf(pluginEnum.getCode())).name(pluginEnum.getName()).config(this.getPluginConfig(pluginEnum, zookeeperUrl)).role(PluginRoleEnum.SYS.getName()).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(pluginEnum.getCode())).build();
        shenyuCacheRepository.saveOrUpdatePluginData(pluginData);
    }

    private String getPluginConfig(PluginEnum pluginEnum, String zookeeperUrl) {
        switch (pluginEnum) {
            case DIVIDE: {
                return "{multiSelectorHandle: 1, multiRuleHandle:0}";
            }
            case DUBBO: {
                return "{\"register\":\"" + zookeeperUrl + "\",\"multiSelectorHandle\":\"1\",\"threadpool\":\"shared\",\"corethreads\":0,\"threads\":2147483647,\"queues\":0}";
            }
            case MOTAN: {
                return "{\"registerProtocol\":\"zk\",\"registerAddress\":\"" + zookeeperUrl + "\",\"corethreads\":0,\"threads\":2147483647,\"queues\":0,\"threadpool\":\"shared\"}";
            }
            case WEB_SOCKET: {
                return "{multiSelectorHandle: 1}";
            }
            case SOFA: {
                return "{\"protocol\":\"zookeeper\",\"register\":\"" + zookeeperUrl + "\",\"threadpool\":\"shared\"}";
            }
            case GRPC: {
                return "{\"multiSelectorHandle\":\"1\",\"multiRuleHandle\":\"0\",\"threadpool\":\"shared\"}";
            }
        }
        return null;
    }

    private String getZookeeperUrl(Map<String, String> annotations, Request request) {
        String zookeeperK8sUrl = annotations.get("shenyu.apache.org/zookeeper-register-address");
        String zookeeperUrl = null;
        String zookeeperK8sIpUrl = IpUtils.getZookeeperHost((String)zookeeperK8sUrl);
        if (IpUtils.isCompleteHost((String)zookeeperK8sIpUrl)) {
            zookeeperUrl = annotations.get("shenyu.apache.org/zookeeper-register-address");
        } else {
            Lister<V1Endpoints> endpointsLister = this.ingressParser.getEndpointsLister();
            LOG.info("endpointsLister:{}", (Object)JsonUtils.toJson(endpointsLister));
            Lister namespace = endpointsLister.namespace(request.getNamespace());
            LOG.info("namespace:{}", (Object)JsonUtils.toJson((Object)namespace));
            V1Endpoints v1Endpoints = (V1Endpoints)namespace.get(zookeeperK8sIpUrl);
            List subsets = v1Endpoints.getSubsets();
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints do not have subsets");
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || addresses.isEmpty()) continue;
                    for (V1EndpointAddress address : addresses) {
                        zookeeperUrl = address.getIp();
                    }
                }
            }
        }
        if (!IpUtils.isCompleteHost((String)zookeeperUrl)) {
            LOG.info("Please enter the correct zookeeperUrl address");
            throw new ShenyuException("zookeeper url:" + zookeeperUrl + " is is error.");
        }
        zookeeperUrl = IpUtils.replaceZookeeperHost((String)zookeeperK8sUrl, (String)zookeeperUrl);
        return zookeeperUrl;
    }

    private boolean checkIngressClass(V1Ingress v1Ingress) {
        if (Objects.nonNull(v1Ingress.getMetadata())) {
            Map annotations = v1Ingress.getMetadata().getAnnotations();
            if (Objects.nonNull(annotations) && Objects.nonNull(annotations.get("kubernetes.io/ingress.class"))) {
                return "shenyu".equals(annotations.get("kubernetes.io/ingress.class"));
            }
            return Objects.nonNull(v1Ingress.getSpec()) && "shenyu".equals(v1Ingress.getSpec().getIngressClassName());
        }
        return false;
    }

    private List<String> deleteSelectorByIngressName(String namespace, String name, String pluginName, String path) {
        List<String> selectorList = IngressSelectorCache.getInstance().get(namespace, name, pluginName);
        if (Objects.nonNull(selectorList) && !selectorList.isEmpty()) {
            for (String selectorId : selectorList) {
                List<RuleData> ruleList = this.shenyuCacheRepository.findRuleDataList(selectorId);
                ArrayList ruleIdList = new ArrayList();
                ruleList.forEach(rule -> ruleIdList.add(rule.getId()));
                for (String id : ruleIdList) {
                    MetaData metaData = this.shenyuCacheRepository.findMetaData(path);
                    if (Objects.nonNull(metaData)) {
                        this.shenyuCacheRepository.deleteMetaData(metaData);
                    }
                    this.shenyuCacheRepository.deleteRuleData(pluginName, selectorId, id);
                }
                this.shenyuCacheRepository.deleteSelectorData(pluginName, selectorId);
            }
        }
        return selectorList;
    }

    private List<Pair<String, String>> parseServiceFromIngress(V1Ingress ingress) {
        ArrayList<Pair<String, String>> res = new ArrayList<Pair<String, String>>();
        if (Objects.isNull(ingress) || Objects.isNull(ingress.getSpec())) {
            return res;
        }
        String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
        String name = ingress.getMetadata().getName();
        String namespacedName = namespace + "/" + name;
        String defaultService = null;
        if (Objects.nonNull(ingress.getSpec().getDefaultBackend()) && Objects.nonNull(ingress.getSpec().getDefaultBackend().getService())) {
            defaultService = ingress.getSpec().getDefaultBackend().getService().getName();
            if (Objects.isNull(ingress.getSpec().getRules())) {
                if (Objects.nonNull(globalDefaultBackend)) {
                    if (((String)((Pair)globalDefaultBackend.getLeft()).getLeft()).equals(namespacedName)) {
                        res.add((Pair<String, String>)Pair.of((Object)namespace, (Object)defaultService));
                    }
                } else {
                    res.add((Pair<String, String>)Pair.of((Object)namespace, (Object)defaultService));
                }
                return res;
            }
        }
        HashSet<String> deduplicateSet = new HashSet<String>();
        if (Objects.isNull(ingress.getSpec().getRules())) {
            return res;
        }
        for (V1IngressRule rule : ingress.getSpec().getRules()) {
            if (!Objects.nonNull(rule.getHttp()) || !Objects.nonNull(rule.getHttp().getPaths())) continue;
            for (V1HTTPIngressPath path : rule.getHttp().getPaths()) {
                if (Objects.nonNull(path.getBackend()) && Objects.nonNull(path.getBackend().getService())) {
                    if (deduplicateSet.contains(path.getBackend().getService().getName())) continue;
                    res.add((Pair<String, String>)Pair.of((Object)namespace, (Object)path.getBackend().getService().getName()));
                    deduplicateSet.add(path.getBackend().getService().getName());
                    continue;
                }
                if (!Objects.nonNull(defaultService) || deduplicateSet.contains(defaultService)) continue;
                res.add((Pair<String, String>)Pair.of((Object)namespace, (Object)defaultService));
                deduplicateSet.add(defaultService);
            }
        }
        return res;
    }

    private boolean needUpdate(V1Ingress oldIngress, V1Ingress currentIngress) {
        return !oldIngress.equals((Object)currentIngress);
    }

    private void addNewIngressConfigToShenyu(V1Ingress v1Ingress, CoreV1Api apiClient) throws IOException {
        V1Ingress ingressCopy = new V1IngressBuilder(v1Ingress).build();
        List<ShenyuMemoryConfig> shenyuMemoryConfigList = this.ingressParser.parse(ingressCopy, apiClient);
        String pluginName = this.getPluginName(ingressCopy);
        for (ShenyuMemoryConfig shenyuMemoryConfig : shenyuMemoryConfigList) {
            if (!Objects.nonNull(shenyuMemoryConfig)) continue;
            this.processShenyuMemoryConfig(shenyuMemoryConfig, v1Ingress, pluginName);
        }
    }

    private void processShenyuMemoryConfig(ShenyuMemoryConfig shenyuMemoryConfig, V1Ingress v1Ingress, String pluginName) throws IOException {
        List<IngressConfiguration> routeConfigList = shenyuMemoryConfig.getRouteConfigList();
        if (CollectionUtils.isEmpty(routeConfigList)) {
            return;
        }
        for (IngressConfiguration routeConfig : routeConfigList) {
            List<MetaData> metaDataList;
            SelectorData selectorData = routeConfig.getSelectorData();
            if (Objects.nonNull(selectorData)) {
                this.processSelectorData(routeConfig, selectorData, v1Ingress, pluginName);
            }
            if (!Objects.nonNull(metaDataList = routeConfig.getMetaDataList())) continue;
            this.processMetaDataList(metaDataList);
        }
        this.processGlobalDefaultBackend(shenyuMemoryConfig, v1Ingress, pluginName);
        this.processTlsConfigurations(shenyuMemoryConfig, v1Ingress);
    }

    private void processSelectorData(IngressConfiguration routeConfig, SelectorData selectorData, V1Ingress v1Ingress, String pluginName) {
        selectorData.setId(IngressSelectorCache.getInstance().generateSelectorId());
        selectorData.setSort(Integer.valueOf(100));
        this.shenyuCacheRepository.saveOrUpdateSelectorData(selectorData);
        List<RuleData> ruleDataList = routeConfig.getRuleDataList();
        if (CollectionUtils.isNotEmpty(ruleDataList)) {
            this.processRuleDataList(ruleDataList, selectorData);
        }
        IngressSelectorCache.getInstance().put(Objects.requireNonNull(v1Ingress.getMetadata()).getNamespace(), v1Ingress.getMetadata().getName(), pluginName, selectorData.getId());
    }

    private void processRuleDataList(List<RuleData> ruleDataList, SelectorData selectorData) {
        for (RuleData ruleData : ruleDataList) {
            if (!Objects.nonNull(ruleData)) continue;
            ruleData.setId(IngressSelectorCache.getInstance().generateRuleId());
            ruleData.setSelectorId(selectorData.getId());
            ruleData.setSort(Integer.valueOf(100));
            this.shenyuCacheRepository.saveOrUpdateRuleData(ruleData);
        }
    }

    private void processMetaDataList(List<MetaData> metaDataList) {
        for (MetaData metaData : metaDataList) {
            if (!Objects.nonNull(metaData)) continue;
            metaData.setId(IngressSelectorCache.getInstance().generateMetaDataId());
            this.shenyuCacheRepository.saveOrUpdateMetaData(metaData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processGlobalDefaultBackend(ShenyuMemoryConfig shenyuMemoryConfig, V1Ingress v1Ingress, String pluginName) {
        Pair<Pair<String, String>, IngressConfiguration> configurationPair = shenyuMemoryConfig.getGlobalDefaultBackend();
        if (!Objects.nonNull(configurationPair)) return;
        Class<IngressReconciler> clazz = IngressReconciler.class;
        synchronized (IngressReconciler.class) {
            if (!Objects.isNull(globalDefaultBackend)) return;
            IngressConfiguration ingressConfiguration = (IngressConfiguration)configurationPair.getRight();
            SelectorData selectorData = ingressConfiguration.getSelectorData();
            this.shenyuCacheRepository.saveOrUpdateSelectorData(selectorData);
            ingressConfiguration.getRuleDataList().forEach(this.shenyuCacheRepository::saveOrUpdateRuleData);
            ingressConfiguration.getMetaDataList().forEach(this.shenyuCacheRepository::saveOrUpdateMetaData);
            globalDefaultBackend = configurationPair;
            IngressSelectorCache.getInstance().put(Objects.requireNonNull(v1Ingress.getMetadata()).getNamespace(), v1Ingress.getMetadata().getName(), pluginName, selectorData.getId());
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void processTlsConfigurations(ShenyuMemoryConfig shenyuMemoryConfig, V1Ingress v1Ingress) throws IOException {
        List<SslCrtAndKeyStream> tlsConfigList = shenyuMemoryConfig.getTlsConfigList();
        if (CollectionUtils.isNotEmpty(tlsConfigList)) {
            String namespace = Objects.requireNonNull(v1Ingress.getMetadata()).getNamespace();
            String ingressName = v1Ingress.getMetadata().getName();
            Set oldDomainSet = Optional.ofNullable(IngressSecretCache.getInstance().removeDomainByIngress(namespace, ingressName)).orElse(new HashSet());
            HashSet<String> newDomainSet = new HashSet<String>();
            for (SslCrtAndKeyStream sslCrtAndKeyStream : tlsConfigList) {
                String domain = sslCrtAndKeyStream.getDomain();
                if (!oldDomainSet.contains(domain) && IngressSecretCache.getInstance().getAndIncrementDomainNums(domain) == 0) {
                    this.shenyuSniAsyncMapping.addSslCertificate((SslCrtAndKey)sslCrtAndKeyStream);
                    LOG.info("Add ssl config for domain {}", (Object)domain);
                }
                newDomainSet.add(domain);
            }
            oldDomainSet.removeAll(newDomainSet);
            for (String domain : oldDomainSet) {
                if (IngressSecretCache.getInstance().getAndDecrementDomainNums(domain) != 1) continue;
                this.shenyuSniAsyncMapping.removeSslCertificate(domain);
                LOG.info("Remove ssl config for domain {}", (Object)domain);
            }
            IngressSecretCache.getInstance().putDomainByIngress(namespace, ingressName, newDomainSet);
        }
    }

    private String getPluginName(V1Ingress ingress) {
        String pluginDubboEnabled = (String)ingress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-dubbo-enabled");
        String pluginMotanEnabled = (String)ingress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-motan-enabled");
        String pluginWebSocketEnabled = (String)ingress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-web-socket-enabled");
        String pluginBrpcEnabled = (String)ingress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-brpc-enabled");
        String pluginGrpcEnabled = (String)ingress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-grpc-enabled");
        String pluginSofaEnabled = (String)ingress.getMetadata().getAnnotations().get("shenyu.apache.org/plugin-sofa-enabled");
        String pluginName = Boolean.TRUE.toString().equals(pluginDubboEnabled) ? PluginEnum.DUBBO.getName() : (Boolean.TRUE.toString().equals(pluginMotanEnabled) ? PluginEnum.MOTAN.getName() : (Boolean.TRUE.toString().equals(pluginWebSocketEnabled) ? PluginEnum.WEB_SOCKET.getName() : (Boolean.TRUE.toString().equals(pluginGrpcEnabled) ? PluginEnum.GRPC.getName() : (Boolean.TRUE.toString().equals(pluginSofaEnabled) ? PluginEnum.SOFA.getName() : PluginEnum.DIVIDE.getName()))));
        return pluginName;
    }
}

