/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotanIngressParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(MotanIngressParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public MotanIngressParser(Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister) {
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec())) {
            V1IngressBackend defaultBackend = ingress.getSpec().getDefaultBackend();
            List rules = ingress.getSpec().getRules();
            List tlsList = ingress.getSpec().getTls();
            String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
            if (Objects.isNull(rules) || CollectionUtils.isEmpty((Collection)rules)) {
                if (Objects.nonNull(defaultBackend) && Objects.nonNull(defaultBackend.getService())) {
                    IngressConfiguration defaultRouteConfig = this.getDefaultRouteConfig(ingress.getMetadata().getAnnotations());
                    res.setGlobalDefaultBackend((Pair<Pair<String, String>, IngressConfiguration>)Pair.of((Object)Pair.of((Object)(namespace + "/" + ingress.getMetadata().getName()), (Object)defaultBackend.getService().getName()), (Object)defaultRouteConfig));
                }
            } else {
                ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
                for (V1IngressRule ingressRule : rules) {
                    List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, Objects.requireNonNull(ingress.getMetadata()).getNamespace(), ingress.getMetadata().getAnnotations(), ingress.getMetadata().getLabels());
                    routeList.addAll(routes);
                }
                res.setRouteConfigList(routeList);
            }
            if (Objects.nonNull(tlsList) && CollectionUtils.isNotEmpty((Collection)tlsList)) {
                ArrayList<SslCrtAndKeyStream> sslList = new ArrayList<SslCrtAndKeyStream>();
                for (V1IngressTLS tls : tlsList) {
                    String secretName = tls.getSecretName();
                    List hosts = tls.getHosts();
                    if (!Objects.nonNull(secretName) || !CollectionUtils.isNotEmpty((Collection)hosts)) continue;
                    try {
                        V1Secret secret = coreV1Api.readNamespacedSecret(secretName, namespace, "ture");
                        if (!Objects.nonNull(secret.getData())) continue;
                        ByteArrayInputStream keyCertChainInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.crt"));
                        ByteArrayInputStream keyInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.key"));
                        hosts.forEach(host -> sslList.add(new SslCrtAndKeyStream(host, keyCertChainInputStream, keyInputStream)));
                    }
                    catch (ApiException e) {
                        LOG.error("parse tls failed ", (Throwable)e);
                    }
                }
                res.setTlsConfigList(sslList);
            }
        }
        return res;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, String namespace, Map<String, String> annotations, Map<String, String> labels) {
        List paths;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData hostCondition = null;
        if (Objects.nonNull(ingressRule.getHost())) {
            hostCondition = new ConditionData();
            hostCondition.setParamType(ParamTypeEnum.URI.getName());
            hostCondition.setOperator(OperatorEnum.EQ.getAlias());
            hostCondition.setParamValue(ingressRule.getHost());
        }
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                OperatorEnum operator;
                String pathPath = path.getPath();
                if (Objects.isNull(pathPath)) continue;
                if ("ImplementationSpecific".equals(path.getPathType())) {
                    operator = OperatorEnum.MATCH;
                } else if ("Prefix".equals(path.getPathType())) {
                    operator = OperatorEnum.STARTS_WITH;
                } else if ("Exact".equals(path.getPathType())) {
                    operator = OperatorEnum.EQ;
                } else {
                    LOG.info("Invalid path type, set it with match operator");
                    operator = OperatorEnum.MATCH;
                }
                ConditionData pathCondition = new ConditionData();
                pathCondition.setOperator(operator.getAlias());
                pathCondition.setParamType(ParamTypeEnum.URI.getName());
                pathCondition.setParamValue(pathPath);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                ConditionData ruleConditionData = new ConditionData();
                ruleConditionData.setParamType(ParamTypeEnum.URI.getName());
                ruleConditionData.setOperator(OperatorEnum.EQ.getAlias());
                ruleConditionData.setParamName(annotations.getOrDefault("shenyu.apache.org/plugin-motan-path", pathPath));
                ArrayList<ConditionData> ruleConditionDataList = new ArrayList<ConditionData>();
                ruleConditionDataList.add(ruleConditionData);
                SelectorData selectorData = SelectorData.builder().pluginId(String.valueOf(PluginEnum.MOTAN.getCode())).pluginName(PluginEnum.MOTAN.getName()).name(pathPath).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).build();
                ArrayList<RuleData> ruleDataList = new ArrayList<RuleData>();
                ArrayList<MetaData> metaDataList = new ArrayList<MetaData>();
                for (String label : labels.keySet()) {
                    Map metadataAnnotations = ((V1Service)this.serviceLister.namespace(namespace).get(labels.get(label))).getMetadata().getAnnotations();
                    List<ConditionData> ruleConditionList = this.getRuleConditionList(metadataAnnotations);
                    RuleData ruleData = this.createRuleData(metadataAnnotations, ruleConditionList);
                    MetaData metaData = this.parseMetaData(metadataAnnotations);
                    ruleDataList.add(ruleData);
                    metaDataList.add(metaData);
                }
                res.add(new IngressConfiguration(selectorData, ruleDataList, metaDataList));
            }
        }
        return res;
    }

    private List<ConditionData> getRuleConditionList(Map<String, String> annotations) {
        ArrayList<ConditionData> ruleConditionList = new ArrayList<ConditionData>();
        ConditionData ruleCondition = new ConditionData();
        ruleCondition.setOperator(OperatorEnum.EQ.getAlias());
        ruleCondition.setParamType(ParamTypeEnum.URI.getName());
        ruleCondition.setParamValue(annotations.get("shenyu.apache.org/plugin-motan-path"));
        ruleConditionList.add(ruleCondition);
        return ruleConditionList;
    }

    private RuleData createRuleData(Map<String, String> metadataAnnotations, List<ConditionData> ruleConditionList) {
        return RuleData.builder().name(metadataAnnotations.get("shenyu.apache.org/plugin-motan-path")).pluginName(PluginEnum.MOTAN.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(ruleConditionList).loged(Boolean.valueOf(true)).enabled(Boolean.valueOf(true)).build();
    }

    private MetaData parseMetaData(Map<String, String> annotations) {
        return MetaData.builder().appName(annotations.get("shenyu.apache.org/plugin-motan-app-name")).path(annotations.get("shenyu.apache.org/plugin-motan-path")).rpcType(annotations.get("shenyu.apache.org/plugin-motan-rpc-type")).rpcExt(annotations.get("shenyu.apache.org/plugin-motan-rpc-expand")).serviceName(annotations.get("shenyu.apache.org/plugin-motan-service-name")).methodName(annotations.get("shenyu.apache.org/plugin-motan-method-name")).parameterTypes(annotations.get("shenyu.apache.org/plugin-motan-params-type")).enabled(Boolean.valueOf(true)).build();
    }

    private IngressConfiguration getDefaultRouteConfig(Map<String, String> annotations) {
        ConditionData conditionData = new ConditionData();
        conditionData.setParamName("default");
        conditionData.setParamType(ParamTypeEnum.URI.getName());
        conditionData.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        conditionData.setParamValue("/**");
        SelectorData selectorData = SelectorData.builder().name("default-selector").sort(Integer.valueOf(Integer.MAX_VALUE)).conditionList(Collections.singletonList(conditionData)).enabled(Boolean.valueOf(true)).id("1").pluginName(PluginEnum.MOTAN.getName()).pluginId(String.valueOf(PluginEnum.MOTAN.getCode())).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode())).build();
        RuleData ruleData = RuleData.builder().selectorId("1").pluginName(PluginEnum.MOTAN.getName()).name("default-rule").matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(Collections.singletonList(conditionData)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(Integer.MAX_VALUE)).build();
        if (Objects.isNull(annotations.get("shenyu.apache.org/plugin-motan-app-name")) || Objects.isNull(annotations.get("shenyu.apache.org/plugin-motan-method-name")) || Objects.isNull(annotations.get("shenyu.apache.org/plugin-motan-path")) || Objects.isNull(annotations.get("shenyu.apache.org/plugin-motan-service-name")) || Objects.isNull(annotations.get("shenyu.apache.org/plugin-motan-rpc-type"))) {
            LOG.error("motan metadata is error, please check motan service. MetaData: [{}]", annotations);
            throw new ShenyuException(annotations + " is is missing.");
        }
        MetaData metaData = MetaData.builder().appName(annotations.get("shenyu.apache.org/plugin-motan-app-name")).path(annotations.get("shenyu.apache.org/plugin-motan-path")).rpcType(annotations.get("shenyu.apache.org/plugin-motan-rpc-type")).rpcExt(annotations.getOrDefault("shenyu.apache.org/plugin-motan-rpc-expand", "")).serviceName(annotations.get("shenyu.apache.org/plugin-motan-service-name")).methodName(annotations.get("shenyu.apache.org/plugin-motan-method-name")).parameterTypes(annotations.getOrDefault("shenyu.apache.org/plugin-motan-params-type", "")).enabled(Boolean.valueOf(true)).build();
        return new IngressConfiguration(selectorData, Arrays.asList(ruleData), Arrays.asList(metaData));
    }
}

