/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.DivideRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DivideIngressParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(DivideIngressParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public DivideIngressParser(Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister) {
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec())) {
            V1IngressBackend defaultBackend = ingress.getSpec().getDefaultBackend();
            List rules = ingress.getSpec().getRules();
            List tlsList = ingress.getSpec().getTls();
            String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
            List<DivideUpstream> defaultUpstreamList = this.parseDefaultService(defaultBackend, namespace);
            if (Objects.isNull(rules) || CollectionUtils.isEmpty((Collection)rules)) {
                if (Objects.nonNull(defaultBackend) && Objects.nonNull(defaultBackend.getService())) {
                    IngressConfiguration defaultRouteConfig = this.getDefaultRouteConfig(defaultUpstreamList, ingress.getMetadata().getAnnotations());
                    res.setGlobalDefaultBackend((Pair<Pair<String, String>, IngressConfiguration>)Pair.of((Object)Pair.of((Object)(namespace + "/" + ingress.getMetadata().getName()), (Object)defaultBackend.getService().getName()), (Object)defaultRouteConfig));
                }
            } else {
                ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
                for (V1IngressRule ingressRule : rules) {
                    List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, defaultUpstreamList, Objects.requireNonNull(ingress.getMetadata()).getNamespace(), ingress.getMetadata().getAnnotations());
                    routeList.addAll(routes);
                }
                res.setRouteConfigList(routeList);
            }
            if (Objects.nonNull(tlsList) && CollectionUtils.isNotEmpty((Collection)tlsList)) {
                ArrayList<SslCrtAndKeyStream> sslList = new ArrayList<SslCrtAndKeyStream>();
                for (V1IngressTLS tls : tlsList) {
                    if (!Objects.nonNull(tls.getSecretName()) || !Objects.nonNull(tls.getHosts()) || !CollectionUtils.isNotEmpty((Collection)tls.getHosts())) continue;
                    try {
                        V1Secret secret = coreV1Api.readNamespacedSecret(tls.getSecretName(), namespace, "ture");
                        if (!Objects.nonNull(secret.getData())) continue;
                        ByteArrayInputStream keyCertChainInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.crt"));
                        ByteArrayInputStream keyInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.key"));
                        tls.getHosts().forEach(host -> sslList.add(new SslCrtAndKeyStream(host, keyCertChainInputStream, keyInputStream)));
                    }
                    catch (ApiException e) {
                        LOG.error("parse tls failed ", (Throwable)e);
                    }
                }
                res.setTlsConfigList(sslList);
            }
        }
        return res;
    }

    private List<DivideUpstream> parseDefaultService(V1IngressBackend defaultBackend, String namespace) {
        ArrayList<DivideUpstream> defaultUpstreamList = new ArrayList<DivideUpstream>();
        if (Objects.nonNull(defaultBackend) && Objects.nonNull(defaultBackend.getService())) {
            String serviceName = defaultBackend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || CollectionUtils.isEmpty((Collection)addresses)) continue;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(defaultBackend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        DivideUpstream upstream = new DivideUpstream();
                        upstream.setUpstreamUrl(upstreamIp + ":" + defaultPort);
                        upstream.setWeight(100);
                        upstream.setProtocol("http://");
                        upstream.setWarmup(0);
                        upstream.setStatus(true);
                        upstream.setUpstreamHost("");
                        defaultUpstreamList.add(upstream);
                    }
                }
            }
        }
        return defaultUpstreamList;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, List<DivideUpstream> defaultUpstream, String namespace, Map<String, String> annotations) {
        List paths;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData hostCondition = null;
        if (Objects.nonNull(ingressRule.getHost())) {
            hostCondition = new ConditionData();
            hostCondition.setParamType(ParamTypeEnum.DOMAIN.getName());
            hostCondition.setOperator(OperatorEnum.EQ.getAlias());
            hostCondition.setParamValue(ingressRule.getHost());
        }
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                OperatorEnum operator;
                String pathPath = path.getPath();
                if (Objects.isNull(pathPath)) continue;
                if ("ImplementationSpecific".equals(path.getPathType())) {
                    operator = OperatorEnum.MATCH;
                } else if ("Prefix".equals(path.getPathType())) {
                    operator = OperatorEnum.STARTS_WITH;
                } else if ("Exact".equals(path.getPathType())) {
                    operator = OperatorEnum.EQ;
                } else {
                    LOG.info("Invalid path type, set it with match operator");
                    operator = OperatorEnum.MATCH;
                }
                ConditionData pathCondition = new ConditionData();
                pathCondition.setOperator(operator.getAlias());
                pathCondition.setParamType(ParamTypeEnum.URI.getName());
                pathCondition.setParamValue(pathPath);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                SelectorData selectorData = SelectorData.builder().pluginId(String.valueOf(PluginEnum.DIVIDE.getCode())).pluginName(PluginEnum.DIVIDE.getName()).name(pathPath).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).build();
                List<DivideUpstream> upstreamList = this.parseUpstream(path.getBackend(), namespace, annotations);
                if (upstreamList.isEmpty()) {
                    upstreamList = defaultUpstream;
                }
                selectorData.setHandle(GsonUtils.getInstance().toJson(upstreamList));
                DivideRuleHandle divideRuleHandle = new DivideRuleHandle();
                if (Objects.nonNull(annotations)) {
                    divideRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
                    divideRuleHandle.setRetry(Integer.parseInt(annotations.getOrDefault("shenyu.apache.org/retry", "3")));
                    divideRuleHandle.setTimeout(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/timeout", "3000")));
                    divideRuleHandle.setHeaderMaxSize(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/header-max-size", "10240")));
                    divideRuleHandle.setRequestMaxSize(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/request-max-size", "102400")));
                }
                RuleData ruleData = RuleData.builder().name(pathPath).pluginName(PluginEnum.DIVIDE.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(conditionList).handle(GsonUtils.getInstance().toJson((Object)divideRuleHandle)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).build();
                res.add(new IngressConfiguration(selectorData, Arrays.asList(ruleData), null));
            }
        }
        return res;
    }

    private String parsePort(V1IngressServiceBackend service) {
        V1ServiceBackendPort servicePort = service.getPort();
        if (Objects.nonNull(servicePort)) {
            String trim;
            Integer portNumber = servicePort.getNumber();
            if (Objects.nonNull(portNumber) && portNumber > 0) {
                return String.valueOf(portNumber);
            }
            String servicePortName = servicePort.getName();
            if (Objects.nonNull(servicePortName) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{trim = servicePortName.trim()})) {
                return trim;
            }
        }
        return null;
    }

    private List<DivideUpstream> parseUpstream(V1IngressBackend backend, String namespace, Map<String, String> annotations) {
        ArrayList<DivideUpstream> upstreamList = new ArrayList<DivideUpstream>();
        if (Objects.nonNull(backend) && Objects.nonNull(backend.getService()) && Objects.nonNull(backend.getService().getName())) {
            String serviceName = backend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            String[] protocol = null;
            if (Objects.nonNull(annotations) && annotations.containsKey("shenyu.apache.org/upstreams-protocol")) {
                protocol = annotations.get("shenyu.apache.org/upstreams-protocol").split(",");
            }
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || addresses.isEmpty()) continue;
                    int i = 0;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(backend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        DivideUpstream upstream = new DivideUpstream();
                        upstream.setUpstreamUrl(upstreamIp + ":" + defaultPort);
                        upstream.setWeight(100);
                        upstream.setProtocol(Objects.isNull(protocol) ? "http://" : protocol[i++]);
                        upstream.setWarmup(0);
                        upstream.setStatus(true);
                        upstream.setUpstreamHost("");
                        upstreamList.add(upstream);
                    }
                }
            }
        }
        return upstreamList;
    }

    private IngressConfiguration getDefaultRouteConfig(List<DivideUpstream> divideUpstream, Map<String, String> annotations) {
        ConditionData conditionData = new ConditionData();
        conditionData.setParamName("default");
        conditionData.setParamType(ParamTypeEnum.URI.getName());
        conditionData.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        conditionData.setParamValue("/**");
        SelectorData selectorData = SelectorData.builder().name("default-selector").sort(Integer.valueOf(Integer.MAX_VALUE)).conditionList(Collections.singletonList(conditionData)).handle(GsonUtils.getInstance().toJson(divideUpstream)).enabled(Boolean.valueOf(true)).id("1").pluginName(PluginEnum.DIVIDE.getName()).pluginId(String.valueOf(PluginEnum.DIVIDE.getCode())).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode())).build();
        DivideRuleHandle divideRuleHandle = new DivideRuleHandle();
        if (Objects.nonNull(annotations)) {
            divideRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
            divideRuleHandle.setRetry(Integer.parseInt(annotations.getOrDefault("shenyu.apache.org/retry", "3")));
            divideRuleHandle.setTimeout(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/timeout", "3000")));
            divideRuleHandle.setHeaderMaxSize(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/header-max-size", "10240")));
            divideRuleHandle.setRequestMaxSize(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/request-max-size", "102400")));
        }
        RuleData ruleData = RuleData.builder().selectorId("1").pluginName(PluginEnum.DIVIDE.getName()).name("default-rule").matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(Collections.singletonList(conditionData)).handle(GsonUtils.getInstance().toJson((Object)divideRuleHandle)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(Integer.MAX_VALUE)).build();
        return new IngressConfiguration(selectorData, Arrays.asList(ruleData), null);
    }
}

