/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.reconciler;

import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Ingress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.cache.IngressSelectorCache;
import org.apache.shenyu.k8s.cache.ServiceIngressCache;
import org.apache.shenyu.k8s.repository.ShenyuCacheRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointsReconciler
implements Reconciler {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointsReconciler.class);
    private final Lister<V1Ingress> ingressLister;
    private final Lister<V1Endpoints> endpointsLister;
    private final ShenyuCacheRepository shenyuCacheRepository;
    private final ApiClient apiClient;

    public EndpointsReconciler(SharedIndexInformer<V1Ingress> ingressInformer, SharedIndexInformer<V1Endpoints> endpointsInformer, ShenyuCacheRepository shenyuCacheRepository, ApiClient apiClient) {
        this.ingressLister = new Lister(ingressInformer.getIndexer());
        this.endpointsLister = new Lister(endpointsInformer.getIndexer());
        this.shenyuCacheRepository = shenyuCacheRepository;
        this.apiClient = apiClient;
    }

    public Result reconcile(Request request) {
        List<Pair<String, String>> ingressList = ServiceIngressCache.getInstance().getIngressName(request.getNamespace(), request.getName());
        if (CollectionUtils.isEmpty(ingressList)) {
            return new Result(false);
        }
        V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(request.getNamespace()).get(request.getName());
        if (Objects.isNull(v1Endpoints)) {
            LOG.info("Cannot find endpoints {}", (Object)request);
            return new Result(false);
        }
        List<DivideUpstream> upstreamList = this.getUpstreamFromEndpoints(v1Endpoints);
        List<SelectorData> totalSelectors = this.shenyuCacheRepository.findSelectorDataList(PluginEnum.DIVIDE.getName());
        HashSet needUpdateSelectorId = new HashSet();
        ingressList.forEach(item -> {
            List<String> selectorIdList = IngressSelectorCache.getInstance().get((String)item.getLeft(), (String)item.getRight(), PluginEnum.DIVIDE.getName());
            needUpdateSelectorId.addAll(selectorIdList);
        });
        totalSelectors.forEach(selectorData -> {
            if (needUpdateSelectorId.contains(selectorData.getId())) {
                SelectorData newSelectorData = SelectorData.builder().id(selectorData.getId()).pluginId(selectorData.getPluginId()).pluginName(selectorData.getPluginName()).name(selectorData.getName()).matchMode(selectorData.getMatchMode()).type(selectorData.getType()).sort(selectorData.getSort()).enabled(selectorData.getEnabled()).logged(selectorData.getLogged()).continued(selectorData.getContinued()).handle(GsonUtils.getInstance().toJson((Object)upstreamList)).conditionList(selectorData.getConditionList()).matchRestful(selectorData.getMatchRestful()).build();
                this.shenyuCacheRepository.saveOrUpdateSelectorData(newSelectorData);
            }
        });
        LOG.info("Update selector for endpoint {}", (Object)request);
        return new Result(false);
    }

    private List<DivideUpstream> getUpstreamFromEndpoints(V1Endpoints v1Endpoints) {
        ArrayList<DivideUpstream> res = new ArrayList<DivideUpstream>();
        List subsets = v1Endpoints.getSubsets();
        if (CollectionUtils.isNotEmpty((Collection)subsets)) {
            for (V1EndpointSubset subset : subsets) {
                List ports = subset.getPorts();
                List addresses = subset.getAddresses();
                if (CollectionUtils.isEmpty((Collection)ports) || CollectionUtils.isEmpty((Collection)addresses)) continue;
                CoreV1EndpointPort endpointPort = ports.stream().filter(coreV1EndpointPort -> "TCP".equals(coreV1EndpointPort.getProtocol())).findFirst().orElseThrow(() -> new ShenyuException("Can't find port from endpoints"));
                String port = null;
                if (endpointPort.getPort() > 0) {
                    port = String.valueOf(endpointPort.getPort());
                } else {
                    String endpointPortName = endpointPort.getName();
                    if (Objects.nonNull(endpointPortName)) {
                        port = endpointPortName;
                    }
                }
                for (V1EndpointAddress address : addresses) {
                    String ip = address.getIp();
                    if (!Objects.nonNull(ip)) continue;
                    DivideUpstream upstream = new DivideUpstream();
                    upstream.setUpstreamUrl(ip + ":" + port);
                    upstream.setWeight(100);
                    upstream.setProtocol("http://");
                    upstream.setWarmup(0);
                    upstream.setStatus(true);
                    upstream.setUpstreamHost("");
                    res.add(upstream);
                }
            }
        }
        return res;
    }
}

