/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.ContextPathParser;
import org.apache.shenyu.k8s.parser.DivideIngressParser;
import org.apache.shenyu.k8s.parser.DubboIngressParser;
import org.apache.shenyu.k8s.parser.GrpcParser;
import org.apache.shenyu.k8s.parser.K8sResourceListParser;
import org.apache.shenyu.k8s.parser.MotanIngressParser;
import org.apache.shenyu.k8s.parser.SofaParser;
import org.apache.shenyu.k8s.parser.WebSocketParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngressParser
implements K8sResourceListParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(IngressParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public IngressParser(SharedIndexInformer<V1Service> serviceInformer, SharedIndexInformer<V1Endpoints> endpointsInformer) {
        this.serviceLister = new Lister(serviceInformer.getIndexer());
        this.endpointsLister = new Lister(endpointsInformer.getIndexer());
    }

    @Override
    public List<ShenyuMemoryConfig> parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ArrayList<ShenyuMemoryConfig> shenyuMemoryConfigList = new ArrayList<ShenyuMemoryConfig>();
        boolean dubboEnabled = this.getBooleanAnnotation(ingress, "shenyu.apache.org/plugin-dubbo-enabled");
        boolean motanEnabled = this.getBooleanAnnotation(ingress, "shenyu.apache.org/plugin-motan-enabled");
        boolean webSocketEnabled = this.getBooleanAnnotation(ingress, "shenyu.apache.org/plugin-web-socket-enabled");
        boolean brpcEnabled = this.getBooleanAnnotation(ingress, "shenyu.apache.org/plugin-brpc-enabled");
        boolean grpcEnabled = this.getBooleanAnnotation(ingress, "shenyu.apache.org/plugin-grpc-enabled");
        boolean sofaEnabled = this.getBooleanAnnotation(ingress, "shenyu.apache.org/plugin-sofa-enabled");
        if (!(dubboEnabled && motanEnabled && sofaEnabled)) {
            this.contextPathParse(ingress, shenyuMemoryConfigList, coreV1Api);
        }
        if (dubboEnabled) {
            DubboIngressParser dubboIngressParser = new DubboIngressParser(this.serviceLister, this.endpointsLister);
            shenyuMemoryConfigList.add(dubboIngressParser.parse(ingress, coreV1Api));
        } else if (motanEnabled) {
            MotanIngressParser motanIngressParser = new MotanIngressParser(this.serviceLister, this.endpointsLister);
            shenyuMemoryConfigList.add(motanIngressParser.parse(ingress, coreV1Api));
        } else if (webSocketEnabled) {
            WebSocketParser webSocketParser = new WebSocketParser(this.serviceLister, this.endpointsLister);
            shenyuMemoryConfigList.add(webSocketParser.parse(ingress, coreV1Api));
        } else if (grpcEnabled) {
            GrpcParser grpcParser = new GrpcParser(this.serviceLister, this.endpointsLister);
            shenyuMemoryConfigList.add(grpcParser.parse(ingress, coreV1Api));
        } else if (sofaEnabled) {
            SofaParser sofaParser = new SofaParser(this.serviceLister, this.endpointsLister);
            shenyuMemoryConfigList.add(sofaParser.parse(ingress, coreV1Api));
        } else {
            DivideIngressParser divideIngressParser = new DivideIngressParser(this.serviceLister, this.endpointsLister);
            shenyuMemoryConfigList.add(divideIngressParser.parse(ingress, coreV1Api));
        }
        return shenyuMemoryConfigList;
    }

    private boolean getBooleanAnnotation(V1Ingress ingress, String annotationKey) {
        String annotationValue = (String)ingress.getMetadata().getAnnotations().get(annotationKey);
        return Objects.nonNull(annotationValue) && Boolean.parseBoolean(annotationValue);
    }

    private void contextPathParse(V1Ingress ingress, List<ShenyuMemoryConfig> shenyuMemoryConfigList, CoreV1Api coreV1Api) {
        List rules = ingress.getSpec().getRules();
        for (V1IngressRule rule : rules) {
            List paths = rule.getHttp().getPaths();
            for (V1HTTPIngressPath path : paths) {
                if (!"Prefix".equals(path.getPathType())) continue;
                ContextPathParser contextPathParser = new ContextPathParser(this.serviceLister, this.endpointsLister);
                shenyuMemoryConfigList.add(contextPathParser.parse(ingress, coreV1Api));
            }
        }
    }

    public Lister<V1Endpoints> getEndpointsLister() {
        return this.endpointsLister;
    }
}

